package com.ptteng.wealth.consign.model.out;

import java.io.Serializable;
import java.math.BigDecimal;

public class BindingBank implements Comparable<BindingBank>, Serializable {

    private static final long serialVersionUID = 2610030552640881838L;
    // 资产账号
    private int fundAccount;
    // 银行代码
    private String bankNo;
    // 账号类别
    private String bkaccountKind;
    // 币种类别
    private String moneyType;
    // 是否是主账号
    private String mainFlag;
    // 客户编号
    private String clientId;
    // 分支代码
    private int branchNo;
    // 银行卡账号
    private String bankAccount;
    // 客户账号
    private String clientAccount;
    // 账户状态
    private String bkaccountStatus;
    // 账户姓名
    private String holderName;
    // 境外标志
    private String foreignFlag;
    // 证件类别
    private String idKind;
    // 证件号码
    private String idNo;
    // 授权码
    private int authorizeCode;
    // 转出金额上限
    private BigDecimal upperLimitOut;
    // 转出金额下限
    private BigDecimal lowerLimitOut;
    // 转进金额上限
    private BigDecimal upperLimitIn;
    // 转进金额下限
    private BigDecimal lowerLimitIn;
    // 银行控制模板
    private int controlModelNo;
    // 银行操作员
    private String bankOperator;
    // 开户日期
    private int openDate;
    // 备注
    private String remark;
    // 定位串
    private String positionStr;
    // 客户分类
    private int clientGroup;
    // 客户分组
    private int roomCode;
    // 存管指定标志
    private String bkaccountRegflag;
    // 允许委托方式
    private String enEntrustWay;
    // 帐户权限
    private String bkaccountRights;
    // 帐户限制
    private String bkaccountRestrict;
    // 银行簿记账号
    private String bookAccount;
    // 省级分行代码
    private String provinceBranch;
    // 地市级分行代码
    private String cityBranch;
    // 县级分行代码
    private String countyBranch;
    // 储蓄所代码
    private String subBranch;
    // 账号最后一个空格之后的数字
    private String lastNumber;
    // 银行类别:0现金易 1证联余额 2普通银行
    private String bankType;

    // 支付方式：见BankTypeConstant 0-快捷，1-网关
    private String cardType;
    // 支付渠道:见BankTypeConstant a-证联融通，b-易宝支付
    private String payWay;
    //使用方式0 标准(直连银行)1 小额(银联)
    private String useType;



    /**
     * @return the useType
     */
    public String getUseType() {
        return useType;
    }

    /**
     * @param useType the useType to set
     */
    public void setUseType(String useType) {
        this.useType = useType;
    }

    public String getLastNumber() {
        return lastNumber;
    }

    public void setLastNumber(String lastNumber) {
        this.lastNumber = lastNumber;
    }

    public int getFundAccount() {
        return fundAccount;
    }

    public void setFundAccount(int fundAccount) {
        this.fundAccount = fundAccount;
    }

    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public String getBkaccountKind() {
        return bkaccountKind;
    }

    public void setBkaccountKind(String bkaccountKind) {
        this.bkaccountKind = bkaccountKind;
    }

    public String getMoneyType() {
        return moneyType;
    }

    public void setMoneyType(String moneyType) {
        this.moneyType = moneyType;
    }

    public String getMainFlag() {
        return mainFlag;
    }

    public void setMainFlag(String mainFlag) {
        this.mainFlag = mainFlag;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getBranchNo() {
        return branchNo;
    }

    public void setBranchNo(int branchNo) {
        this.branchNo = branchNo;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getClientAccount() {
        return clientAccount;
    }

    public void setClientAccount(String clientAccount) {
        this.clientAccount = clientAccount;
    }

    public String getBkaccountStatus() {
        return bkaccountStatus;
    }

    public void setBkaccountStatus(String bkaccountStatus) {
        this.bkaccountStatus = bkaccountStatus;
    }

    public String getHolderName() {
        return holderName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getForeignFlag() {
        return foreignFlag;
    }

    public void setForeignFlag(String foreignFlag) {
        this.foreignFlag = foreignFlag;
    }

    public String getIdKind() {
        return idKind;
    }

    public void setIdKind(String idKind) {
        this.idKind = idKind;
    }

    public String getIdNo() {
        return idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public int getAuthorizeCode() {
        return authorizeCode;
    }

    public void setAuthorizeCode(int authorizeCode) {
        this.authorizeCode = authorizeCode;
    }

    public BigDecimal getUpperLimitOut() {
        return upperLimitOut;
    }

    public void setUpperLimitOut(BigDecimal upperLimitOut) {
        this.upperLimitOut = upperLimitOut;
    }

    public BigDecimal getLowerLimitOut() {
        return lowerLimitOut;
    }

    public void setLowerLimitOut(BigDecimal lowerLimitOut) {
        this.lowerLimitOut = lowerLimitOut;
    }

    public BigDecimal getUpperLimitIn() {
        return upperLimitIn;
    }

    public void setUpperLimitIn(BigDecimal upperLimitIn) {
        this.upperLimitIn = upperLimitIn;
    }

    public BigDecimal getLowerLimitIn() {
        return lowerLimitIn;
    }

    public void setLowerLimitIn(BigDecimal lowerLimitIn) {
        this.lowerLimitIn = lowerLimitIn;
    }

    public int getControlModelNo() {
        return controlModelNo;
    }

    public void setControlModelNo(int controlModelNo) {
        this.controlModelNo = controlModelNo;
    }

    public String getBankOperator() {
        return bankOperator;
    }

    public void setBankOperator(String bankOperator) {
        this.bankOperator = bankOperator;
    }

    public int getOpenDate() {
        return openDate;
    }

    public void setOpenDate(int openDate) {
        this.openDate = openDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPositionStr() {
        return positionStr;
    }

    public void setPositionStr(String positionStr) {
        this.positionStr = positionStr;
    }

    public int getClientGroup() {
        return clientGroup;
    }

    public void setClientGroup(int clientGroup) {
        this.clientGroup = clientGroup;
    }

    public int getRoomCode() {
        return roomCode;
    }

    public void setRoomCode(int roomCode) {
        this.roomCode = roomCode;
    }

    public String getBkaccountRegflag() {
        return bkaccountRegflag;
    }

    public void setBkaccountRegflag(String bkaccountRegflag) {
        this.bkaccountRegflag = bkaccountRegflag;
    }

    public String getEnEntrustWay() {
        return enEntrustWay;
    }

    public void setEnEntrustWay(String enEntrustWay) {
        this.enEntrustWay = enEntrustWay;
    }

    public String getBkaccountRights() {
        return bkaccountRights;
    }

    public void setBkaccountRights(String bkaccountRights) {
        this.bkaccountRights = bkaccountRights;
    }

    public String getBkaccountRestrict() {
        return bkaccountRestrict;
    }

    public void setBkaccountRestrict(String bkaccountRestrict) {
        this.bkaccountRestrict = bkaccountRestrict;
    }

    public String getBookAccount() {
        return bookAccount;
    }

    public void setBookAccount(String bookAccount) {
        this.bookAccount = bookAccount;
    }

    public String getProvinceBranch() {
        return provinceBranch;
    }

    public void setProvinceBranch(String provinceBranch) {
        this.provinceBranch = provinceBranch;
    }

    public String getCityBranch() {
        return cityBranch;
    }

    public void setCityBranch(String cityBranch) {
        this.cityBranch = cityBranch;
    }

    public String getCountyBranch() {
        return countyBranch;
    }

    public void setCountyBranch(String countyBranch) {
        this.countyBranch = countyBranch;
    }

    public String getSubBranch() {
        return subBranch;
    }

    public void setSubBranch(String subBranch) {
        this.subBranch = subBranch;
    }

    public String getBankType() {
        return bankType;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    /**
     * @return the cardType
     */
    public String getCardType() {
        return cardType;
    }

    /**
     * @param cardType
     *            the cardType to set
     */
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getPayWay() {
        return payWay;
    }

    public void setPayWay(String payWay) {
        this.payWay = payWay;
    }

    @Override
    public int compareTo(BindingBank o) {

        return o.mainFlag.compareTo(this.mainFlag);
    }

    @Override
    public String toString() {
        return "BindingBank{" +
                "authorizeCode=" + authorizeCode +
                ", fundAccount=" + fundAccount +
                ", bankNo='" + bankNo + '\'' +
                ", bkaccountKind='" + bkaccountKind + '\'' +
                ", moneyType='" + moneyType + '\'' +
                ", mainFlag='" + mainFlag + '\'' +
                ", clientId='" + clientId + '\'' +
                ", branchNo=" + branchNo +
                ", bankAccount='" + bankAccount + '\'' +
                ", clientAccount='" + clientAccount + '\'' +
                ", bkaccountStatus='" + bkaccountStatus + '\'' +
                ", holderName='" + holderName + '\'' +
                ", foreignFlag='" + foreignFlag + '\'' +
                ", idKind='" + idKind + '\'' +
                ", idNo='" + idNo + '\'' +
                ", upperLimitOut=" + upperLimitOut +
                ", lowerLimitOut=" + lowerLimitOut +
                ", upperLimitIn=" + upperLimitIn +
                ", lowerLimitIn=" + lowerLimitIn +
                ", controlModelNo=" + controlModelNo +
                ", bankOperator='" + bankOperator + '\'' +
                ", openDate=" + openDate +
                ", remark='" + remark + '\'' +
                ", positionStr='" + positionStr + '\'' +
                ", clientGroup=" + clientGroup +
                ", roomCode=" + roomCode +
                ", bkaccountRegflag='" + bkaccountRegflag + '\'' +
                ", enEntrustWay='" + enEntrustWay + '\'' +
                ", bkaccountRights='" + bkaccountRights + '\'' +
                ", bkaccountRestrict='" + bkaccountRestrict + '\'' +
                ", bookAccount='" + bookAccount + '\'' +
                ", provinceBranch='" + provinceBranch + '\'' +
                ", cityBranch='" + cityBranch + '\'' +
                ", countyBranch='" + countyBranch + '\'' +
                ", subBranch='" + subBranch + '\'' +
                ", lastNumber='" + lastNumber + '\'' +
                ", bankType='" + bankType + '\'' +
                ", cardType='" + cardType + '\'' +
                ", payWay='" + payWay + '\'' +
                ", useType='" + useType + '\'' +
                '}';
    }
}
