package com.ptteng.wealth.consign.model.out;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 余额查询（9902）
 * 
 * @author guozhixing
 * 
 */
public class BalanceInquiryOut extends CommonOut implements Serializable {
	private static final long serialVersionUID = 4164214133634741304L;
	// 商户的系统日期，YYYYMMDD
	private int fundDate;
	// 商户的时间戳，HHMMSS
	private int fundTime;
	// 商户系统流水号。需要保证一个交易日中流水号的唯一性
	private String fundSeqId;
	
	//余额总额=可用资金+在途资金
	private BigDecimal totalAmt;
	
	// 可用资金
	private BigDecimal transAmt;
	
	//在途资金
	private BigDecimal redeeTransitmAmt;
	
	// 应答码，参考附录
	private String respCode;
	// 业务应答描述
	private String respDesc;
	// 保留域，接收方必须原样回送该字段数据
	private String resv;
	//保证金金额
	private BigDecimal marginAmt;
	/**
	 * @return the marginAmt
	 */
	public BigDecimal getMarginAmt() {
		return marginAmt;
	}

	/**
	 * @param marginAmt the marginAmt to set
	 */
	public void setMarginAmt(BigDecimal marginAmt) {
		this.marginAmt = marginAmt;
	}

	/**
	 * @return the proRiskAmt
	 */
	public BigDecimal getProRiskAmt() {
		return proRiskAmt;
	}

	/**
	 * @param proRiskAmt the proRiskAmt to set
	 */
	public void setProRiskAmt(BigDecimal proRiskAmt) {
		this.proRiskAmt = proRiskAmt;
	}

	//风险准备金金额
	private BigDecimal proRiskAmt;

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public BigDecimal getTransAmt() {
		return transAmt;
	}

	public void setTransAmt(BigDecimal transAmt) {
		this.transAmt = transAmt;
	}

	public String getRespCode() {
		return respCode;
	}

	public void setRespCode(String respCode) {
		this.respCode = respCode;
	}

	public String getRespDesc() {
		return respDesc;
	}

	public void setRespDesc(String respDesc) {
		this.respDesc = respDesc;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public BigDecimal getRedeeTransitmAmt() {
		return redeeTransitmAmt;
	}

	public void setRedeeTransitmAmt(BigDecimal redeeTransitmAmt) {
		this.redeeTransitmAmt = redeeTransitmAmt;
	}

	public BigDecimal getTotalAmt() {
		return totalAmt;
	}

	public void setTotalAmt(BigDecimal totalAmt) {
		this.totalAmt = totalAmt;
	}


	
}
