package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * 证联融通-提现流水查询(9904)
 * 
 */
public class WithdrawWaterQueryIn extends CommonIn {
	private static final long serialVersionUID = -3610116160402388678L;
	
	// 交易密码
	private String password;
	//(不需传入，接口统一设置)商户的系统日期，YYYYMMDD
	private int fundDate;
	//(不需传入，接口统一设置) 商户的时间戳，HHMMSS
	private int fundTime;
	//(不需传入，接口统一设置) 商户系统流水号。需要保证一个交易日中流水号的唯一性
	private String fundSeqId;
	// 客户的姓名
	private String userNameText;
	// 证件类型，参考附录
	private String certType = "0";
	// 证件号码
	private String certId;
	// 当前页数
	private int currentPage;
	// 当前页显示条数,如果查询全部数据，设置为-1
	private int pageSize;
	// 开始日期
	private int startDate;
	// 结束日期
	private int endDate;
	// 待查询交易流水号
	private String querySeqId;
	// 保留域，接收方必须原样回送该字段数据
	private String resv;

	
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getCertType() {
		return certType;
	}

	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getCertId() {
		return certId;
	}

	public void setCertId(String certId) {
		this.certId = certId;
	}

	public int getCurrentPage() {
		return currentPage;
	}

	public void setCurrentPage(int currentPage) {
		this.currentPage = currentPage;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public int getStartDate() {
		return startDate;
	}

	public void setStartDate(int startDate) {
		this.startDate = startDate;
	}

	public int getEndDate() {
		return endDate;
	}

	public void setEndDate(int endDate) {
		this.endDate = endDate;
	}

	public String getQuerySeqId() {
		return querySeqId;
	}

	public void setQuerySeqId(String querySeqId) {
		this.querySeqId = querySeqId;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}
	
	public String toString() {
		return ReflectionToStringBuilder.toStringExclude(this, "password");
	}
}
