package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 余额提现限制查询（9909）
 * 
 * @author 郭智星
 * 
 */
public class WithdrawLimitIn extends CommonIn {

	private static final long serialVersionUID = 7925013395503563313L;
	// 功能编号
	private int functionId;
	// 用户编号
	private String userId;
	// 分支代码
	private int branchNo;
	// 资产账号
	private int fundAccount;
	// 商户的系统日期，YYYYMMDD
	private int fundDate;
	// 商户的时间戳，HHMMSS
	private int fundTime;
	// 客户的姓名
	private String userNameText;
	// 商户系统流水号。格式为YYYYMMDD+509+序列，商户流水必须唯一
	private String fundSeqId;
	// 保留域，接收方必须原样回送该字段数据
	private String resv;

	public int getFunctionId() {
		return functionId;
	}

	public void setFunctionId(int functionId) {
		this.functionId = functionId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public int getBranchNo() {
		return branchNo;
	}

	public void setBranchNo(int branchNo) {
		this.branchNo = branchNo;
	}

	public int getFundAccount() {
		return fundAccount;
	}

	public void setFundAccount(int fundAccount) {
		this.fundAccount = fundAccount;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
}
