package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

import java.math.BigDecimal;

public class WithdrawCashIn extends CommonIn {
	private static final long serialVersionUID = 6571799252354306376L;

	// 交易密码
	private String password;
	// (不需填写，service统一处理) 商户的系统日期，YYYYMMDD
	private int fundDate;
	// (不需填写，service统一处理) 商户的时间戳，HHMMSS
	private int fundTime;
	// (不需填写，service统一处理) 商户系统流水号。需要保证一个交易日中流水号的唯一性
	private String fundSeqId;
	// 客户的姓名
	private String userNameText;
	// 证件类型，参考附录
	private String certType = "0";
	// 证件号码
	private String certId;
	// 提现银行代码，参见附录
	private String bankCode;
	// 银行卡号
	private String cardNo;
	// 提现金额
	private BigDecimal transAmt;
	// (不需填写，service统一处理)保留域，接收方必须原样回送该字段数据
	private String resv = "resv";

	// 提现方式：0 快速提现1 普通提现
	private String withdrawType = "1";

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getCertType() {
		return certType;
	}

	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getCertId() {
		return certId;
	}

	public void setCertId(String certId) {
		this.certId = certId;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public BigDecimal getTransAmt() {
		return transAmt;
	}

	public void setTransAmt(BigDecimal transAmt) {
		this.transAmt = transAmt;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public String getWithdrawType() {
		return withdrawType;
	}

	public void setWithdrawType(String withdrawType) {
		this.withdrawType = withdrawType;
	}

	public String toString() {
		return ReflectionToStringBuilder.toStringExclude(this, new String[] {
				"password", "cardNo" });
	}
}
