package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

import java.math.BigDecimal;

/**
 * 
 * @ClassName: TransferCapitalIn 
 * @Description: 证联融通-资金调拨(9912)
 * @author ykwang 
 * @date 2015-5-8 上午11:20:46 
 *
 */
public class TransferCapitalIn extends CommonIn {

	private static final long serialVersionUID = -8853133391237971966L;
	
	// 交易密码
	private String password;
	// 商户的系统日期，YYYYMMDD
	private int fundDate;
	// 商户的时间戳，HHMMSS
	private int fundTime;
	// 客户的姓名
	private String userNameText;
	// 商户系统流水号。需要保证一个交易日中流水号的唯一性
	private String fundSeqId;
	// 交易金额
	private BigDecimal tradeAmt;
	// 00：余额划拨到风险准备金 01：余额划拨到保证金 02:风险准备金划拨到余额 03:保证金划拨到余额
	private String businessType;
	// 保留域，接收方必须原样回送该字段数据
	private String resv;

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public BigDecimal getTradeAmt() {
		return tradeAmt;
	}

	public void setTradeAmt(BigDecimal tradeAmt) {
		this.tradeAmt = tradeAmt;
	}

	public String getBusinessType() {
		return businessType;
	}

	public void setBusinessType(String businessType) {
		this.businessType = businessType;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public String toString() {
		return ReflectionToStringBuilder.toStringExclude(this, "password");
	}
}
