package com.ptteng.wealth.consign.model.in;


import com.ptteng.wealth.consign.constant.FundChargeTypeConstant;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

import java.math.BigInteger;

/**
 * 酒交所产品提货申请-- 9950、9952
 */
public class SpiritDeliveryIn extends CommonIn {

	/**
	 * 提货方式-物流
	 */
	public static final String DeliveryWay_Logistics = "1";
	
	/**
	 * 更新操作
	 */
	public static final int ActionIn_Update = 0;
	
	/**
	 * 撤销操作
	 */
	public static final int ActionIn_Cancel = 1;

    public SpiritDeliveryIn(int branchNo, int functionId, int fundAccount, String userId, int actionIn, String address,  BigInteger amount,  String clientName, String deliveryWay, String fundCode, String fundCompany,String mobiletelephone,   String password, String zipcode) {
        super(branchNo, functionId, fundAccount, "", userId);
        this.actionIn = actionIn;
        this.address = address;
        this.amount = amount;
        this.clientName = clientName;
        this.deliveryWay = deliveryWay;
        this.fundCode = fundCode;
        this.fundCompany = fundCompany;
        this.mobiletelephone = mobiletelephone;
        this.password = password;
        this.zipcode = zipcode;
    }

    /**
	 * 发票类型：0-普票
	 */
	public static final String InvoiceType_Normal = "0";
	
	/**
	 * 发票类型：1-专票
	 */
	public static final String InvoiceType_Designed = "1";

	
	/**
	 * 交易密码
	 */
	private String password;
	
	
	/**
	 * 合同号 ，9952(修改提货申请使用)
	 */
	private String outSerialNo;

	/**
	 * 0 修改 1 撤消 9952(修改提货申请使用)）
	 */
	private  int actionIn;


	/**
	 * 提货方式，1 物流
	 */
	private String deliveryWay = DeliveryWay_Logistics;

	/**
	 * 产品代码
	 */
	private String fundCode;

	/**
	 * 产品发行商
	 */
	private String fundCompany;
	/**
	 * 收费方式
	 */
	private String chargeType = FundChargeTypeConstant.BEFORE;

	/**
	 * 提货数量 修改时若为空，用原值
	 */
	private java.math.BigInteger amount;

	/**
	 * 收货人 修改时若为空，用原值
	 */
	private String clientName;

	/**
	 * 邮编 修改时若为空，用原值
	 */
	private String zipcode;

	/**
	 * 收货地址 修改时若为空，用原值
	 */
	private String address;

	/**
	 * 联系电话(可为null) 修改时若为空，用原值
	 */
	private String phonecode;

	/**
	 * 手机号 修改时若为空，用原值
	 */
	private String mobiletelephone;


	  /**
	   * 发票类型：0-普票,1-专票
	   */
	  private String invoiceType;

	  /**
	   * 发票抬头
	   */
	  private String invoiceTitle;

	  /**
	   * 单位名称
	   */
	  private String companyName;

	 /**
	  * 纳税人识别号
	  */
	  private String taxpayerNo;

	 /**
	  * 注册地址
	  */
	  private String registeredAddress;

	 /**
	  * 注册电话
	  */
	  private String registeredPhone;

	  /**
	   * 开户银行
	   */
	  private String bankNoInvoice;

	  /**
	   * 开户账号
	   */
	  private String bankAccountInvoice;

	  /**
	   * 收票人
	   */
	  private String clientNameRec;

	  /**
	   * 收票人邮编
	   */
	  private String zipcodeRec;

	  /**
	   * 收票人地址
	   */
	  private String addressRec;

	  /**
	   * 收票人手机号
	   */
	  private String mobiletelephoneRec;

	  /**
	   * 备注
	   */
	  private String remark;




	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getDeliveryWay() {
		return deliveryWay;
	}

	public void setDeliveryWay(String deliveryWay) {
		this.deliveryWay = deliveryWay;
	}

	public String getFundCode() {
		return fundCode;
	}

	public void setFundCode(String fundCode) {
		this.fundCode = fundCode;
	}

	public java.math.BigInteger getAmount() {
		return amount;
	}

	public void setAmount(java.math.BigInteger amount) {
		this.amount = amount;
	}

	public String getClientName() {
		return clientName;
	}

	public void setClientName(String clientName) {
		this.clientName = clientName;
	}

	public String getZipcode() {
		return zipcode;
	}

	public void setZipcode(String zipcode) {
		this.zipcode = zipcode;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getPhonecode() {
		return phonecode;
	}

	public void setPhonecode(String phonecode) {
		this.phonecode = phonecode;
	}

	public String getMobiletelephone() {
		return mobiletelephone;
	}

	public void setMobiletelephone(String mobiletelephone) {
		this.mobiletelephone = mobiletelephone;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public String getOutSerialNo() {
		return outSerialNo;
	}

	public void setOutSerialNo(String outSerialNo) {
		this.outSerialNo = outSerialNo;
	}

	public int getActionIn() {
		return actionIn;
	}

	public void setActionIn(int actionIn) {
		this.actionIn = actionIn;
	}


	public String getFundCompany() {
		return fundCompany;
	}

	public void setFundCompany(String fundCompany) {
		this.fundCompany = fundCompany;
	}

	public String getChargeType() {
		return chargeType;
	}

	public void setChargeType(String chargeType) {
		this.chargeType = chargeType;
	}


	public String getInvoiceType() {
		return invoiceType;
	}

	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getInvoiceTitle() {
		return invoiceTitle;
	}

	public void setInvoiceTitle(String invoiceTitle) {
		this.invoiceTitle = invoiceTitle;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getTaxpayerNo() {
		return taxpayerNo;
	}

	public void setTaxpayerNo(String taxpayerNo) {
		this.taxpayerNo = taxpayerNo;
	}

	public String getRegisteredAddress() {
		return registeredAddress;
	}

	public void setRegisteredAddress(String registeredAddress) {
		this.registeredAddress = registeredAddress;
	}

	public String getRegisteredPhone() {
		return registeredPhone;
	}

	public void setRegisteredPhone(String registeredPhone) {
		this.registeredPhone = registeredPhone;
	}

	public String getBankNoInvoice() {
		return bankNoInvoice;
	}

	public void setBankNoInvoice(String bankNoInvoice) {
		this.bankNoInvoice = bankNoInvoice;
	}

	public String getBankAccountInvoice() {
		return bankAccountInvoice;
	}

	public void setBankAccountInvoice(String bankAccountInvoice) {
		this.bankAccountInvoice = bankAccountInvoice;
	}

	public String getClientNameRec() {
		return clientNameRec;
	}

	public void setClientNameRec(String clientNameRec) {
		this.clientNameRec = clientNameRec;
	}

	public String getZipcodeRec() {
		return zipcodeRec;
	}

	public void setZipcodeRec(String zipcodeRec) {
		this.zipcodeRec = zipcodeRec;
	}

	public String getAddressRec() {
		return addressRec;
	}

	public void setAddressRec(String addressRec) {
		this.addressRec = addressRec;
	}

	public String getMobiletelephoneRec() {
		return mobiletelephoneRec;
	}

	public void setMobiletelephoneRec(String mobiletelephoneRec) {
		this.mobiletelephoneRec = mobiletelephoneRec;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}


	private static final long serialVersionUID = -8502336567992954295L;

	public String toString() {
		return ReflectionToStringBuilder.toStringExclude(this, "password");
	}
}
