package com.ptteng.wealth.consign.model.in;

import java.math.BigDecimal;

import com.ptteng.wealth.consign.constant.BankTypeConstant;
import com.ptteng.wealth.consign.constant.FundChargeTypeConstant;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * 酒交所产品购买 (9956)
 */
public class SpiritBuyIn extends CommonIn {

    // 支付方式-银行卡
    public static final String PayType_Bank = "0";
    // 支付方式-金汇宝
    public static final String PayType_Current = "4";
    // 支付方式-金汇宝+银行卡
    public static final String PayType_Bank_Current = "5";
    //支付方式-银行卡+红包
    public static final String PayType_Bank_Redbao = "8";
    //支付方式-银行卡+活宝+红包
    public static final String PayType_Bank_Current_Redbao = "9";
    //支付方式-活宝+红包
    public static final String PayType_Current_Redbao = "a";
    private static final long serialVersionUID = 8610909129433392783L;
    private String password;
    // 酒交所产品发行券商
    private String fundCompany;

    // 酒交所产品代码
    private String fundCode;
    // 收费类型：0-前端，1-后端，2-混合
    private String chargeType = FundChargeTypeConstant.BEFORE;
    // 用户的移动号码
    private String mobiletelephone;
    // 支付方式： 0 银行卡；4 金汇宝；5 金汇宝+银行卡
    private String payType;
    // 银行号 若非银行卡支付为空
    private String bankNo;
    // 银行帐号 若非银行卡支付为空
    private String bankAccount;
    // 金汇宝设立基金公司，若银行卡支付为空
    private String cashFundCompany;
    // 金汇宝基金代码，若银行卡支付为空
    private String cashFundCode;
    // 金汇宝收费类型
    private java.lang.String cashChargeType = FundChargeTypeConstant.BEFORE;
    // 绑定类别,0 快捷绑卡1 网关绑卡
    private String tiedCardType = BankTypeConstant.TIED_CARD_TYPE_SHORTCUT;
    // 支付金额
    private BigDecimal amount;
    // 用户金汇宝 可用份额
    private BigDecimal userEnableShare;
    // 用户金汇宝 可支付金额
    private BigDecimal userEnableBalance;
    // 华创资金密码
    private String gtFundPassword;
    // 滚存标志 1关闭，2开启
    private java.lang.String deferStatus;
    //红包使用金额
    private java.math.BigDecimal occurBalanceHb;
    //红包标识字符串
    private String positionStrHb;

    public SpiritBuyIn(int branchNo, int fundAccount, String opEntrustWay, String userId, BigDecimal amount, String bankAccount,
                       String bankNo, String cashChargeType, String cashFundCode, String cashFundCompany, String chargeType,
                       String deferStatus, String fundCode, String fundCompany, String gtFundPassword, String mobiletelephone,
                       BigDecimal occurBalanceHb, String password, String payType, String positionStrHb, String tiedCardType,
                       BigDecimal userEnableBalance, BigDecimal userEnableShare) {
        super(branchNo, 0, fundAccount, opEntrustWay, userId);
        this.amount = amount;
        this.bankAccount = bankAccount;
        this.bankNo = bankNo;
        this.cashChargeType = cashChargeType;
        this.cashFundCode = cashFundCode;
        this.cashFundCompany = cashFundCompany;
        this.chargeType = chargeType;
        this.deferStatus = deferStatus;
        this.fundCode = fundCode;
        this.fundCompany = fundCompany;
        this.gtFundPassword = gtFundPassword;
        this.mobiletelephone = mobiletelephone;
        this.occurBalanceHb = occurBalanceHb;
        this.password = password;
        this.payType = payType;
        this.positionStrHb = positionStrHb;
        this.tiedCardType = tiedCardType;
        this.userEnableBalance = userEnableBalance;
        this.userEnableShare = userEnableShare;
    }

    /**
     * @return the occurBalanceHb
     */
    public java.math.BigDecimal getOccurBalanceHb() {
        return occurBalanceHb;
    }

    /**
     * @param occurBalanceHb the occurBalanceHb to set
     */
    public void setOccurBalanceHb(java.math.BigDecimal occurBalanceHb) {
        this.occurBalanceHb = occurBalanceHb;
    }

    /**
     * @return the positionStrHb
     */
    public String getPositionStrHb() {
        return positionStrHb;
    }

    /**
     * @param positionStrHb the positionStrHb to set
     */
    public void setPositionStrHb(String positionStrHb) {
        this.positionStrHb = positionStrHb;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFundCompany() {
        return fundCompany;
    }

    public void setFundCompany(String fundCompany) {
        this.fundCompany = fundCompany;
    }

    public String getFundCode() {
        return fundCode;
    }

    public void setFundCode(String fundCode) {
        this.fundCode = fundCode;
    }

    public String getMobiletelephone() {
        return mobiletelephone;
    }

    public void setMobiletelephone(String mobiletelephone) {
        this.mobiletelephone = mobiletelephone;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getCashFundCompany() {
        return cashFundCompany;
    }

    public void setCashFundCompany(String cashFundCompany) {
        this.cashFundCompany = cashFundCompany;
    }

    public String getCashFundCode() {
        return cashFundCode;
    }

    public void setCashFundCode(String cashFundCode) {
        this.cashFundCode = cashFundCode;
    }

    public String getTiedCardType() {
        return tiedCardType;
    }

    public void setTiedCardType(String tiedCardType) {
        this.tiedCardType = tiedCardType;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getUserEnableShare() {
        return userEnableShare;
    }

    public void setUserEnableShare(BigDecimal userEnableShare) {
        this.userEnableShare = userEnableShare;
    }

    public BigDecimal getUserEnableBalance() {
        return userEnableBalance;
    }

    public void setUserEnableBalance(BigDecimal userEnableBalance) {
        this.userEnableBalance = userEnableBalance;
    }

    public String getChargeType() {
        return chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public java.lang.String getCashChargeType() {
        return cashChargeType;
    }

    public void setCashChargeType(java.lang.String cashChargeType) {
        this.cashChargeType = cashChargeType;
    }

    public int getFunctionId() {
        return functionId;
    }

    public void setFunctionId(int functionId) {
        this.functionId = functionId;
    }

    public String getGtFundPassword() {
        return gtFundPassword;
    }

    public void setGtFundPassword(String gtFundPassword) {
        this.gtFundPassword = gtFundPassword;
    }


    public java.lang.String getDeferStatus() {
        return deferStatus;
    }

    public void setDeferStatus(java.lang.String deferStatus) {
        this.deferStatus = deferStatus;
    }

    public String toString() {
        return ReflectionToStringBuilder.toStringExclude(this, new String[]{
                "password", "bankAccount", "gtFundPassword"});
    }

}
