package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

import java.math.BigDecimal;

/**
 * 充值（9900）
 * 
 * @author guozhixing
 * 
 */
public class RechargeIn extends CommonIn  {

	private static final long serialVersionUID = -8590389571088447897L;
	
	// 交易密码
	private String password;
	// 商户的系统日期，YYYYMMDD
	private int fundDate;
	// 商户的时间戳，HHMMSS
	private int fundTime;
	// 商户系统流水号。需要保证一个交易日中流水号的唯一性
	private String fundSeqId;
	// 客户的姓名
	private String userNameText;
	// 证件类型，参考附录
	private String certType = "0";
	// 证件号码
	private String certId;
	// 银行代码，参见附录
	private String bankCode;
	// 银行卡号
	private String cardNo;
	// 充值金额
	private BigDecimal transAmt;
	// 保留域，接收方必须原样回送该字段数据
	private String resv;

	// 支付方式：见BankTypeConstant 0-快捷，1-网关
	private String tiedCardType = "0";
	// 华创资金密码
	private String gtFundPassword;
	
	//00：余额充值 01：保证金充值 02:风险准备金充值
	private String businessType;
	//渠道来源，配资平台：pz
	private String channelResource;

	

	public String getBusinessType() {
		return businessType;
	}

	public void setBusinessType(String businessType) {
		this.businessType = businessType;
	}

	public String getChannelResource() {
		return channelResource;
	}

	public void setChannelResource(String channelResource) {
		this.channelResource = channelResource;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getCertType() {
		return certType;
	}

	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getCertId() {
		return certId;
	}

	public void setCertId(String certId) {
		this.certId = certId;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public BigDecimal getTransAmt() {
		return transAmt;
	}

	public void setTransAmt(BigDecimal transAmt) {
		this.transAmt = transAmt;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	/**
	 * @return the tiedCardType
	 */
	public String getTiedCardType() {
		return tiedCardType;
	}

	/**
	 * @param tiedCardType
	 *            the tiedCardType to set
	 */
	public void setTiedCardType(String tiedCardType) {
		this.tiedCardType = tiedCardType;
	}

	public String getGtFundPassword() {
		return gtFundPassword;
	}

	public void setGtFundPassword(String gtFundPassword) {
		this.gtFundPassword = gtFundPassword;
	}

	public String toString() {
		return ReflectionToStringBuilder.toStringExclude(this, new String[] {
				"password", "cardNo", "gtFundPassword" });
	}

}
