package com.ptteng.wealth.consign.model.in;

import java.io.Serializable;
import java.math.BigDecimal;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * 开户入参实体 9950
 *
 * @author yhye
 * @2012-11-2上午09:19:47
 */
public class OpenAccountIn implements Serializable {

    private static final long serialVersionUID = -237694114823033100L;

    // 功能编号:9500

    public OpenAccountIn() {
    }

    public OpenAccountIn(int actionIn, String address, String cityNo, String clientName, String eduLevel, String eMail, int functionId, String idKind, String idNo, BigDecimal income, String mobiletelephone, String moneyType, String opEntrustWay, String password, String phonecode, String provinceNo, String remark, int riskLevel, String userId, String vocation, String zipcode) {
        this.actionIn = actionIn;
        this.address = address;
        this.cityNo = cityNo;
        this.clientName = clientName;
        this.eduLevel = eduLevel;
        this.eMail = eMail;
        this.functionId = functionId;
        this.idKind = idKind;
        this.idNo = idNo;
        this.income = income;
        this.mobiletelephone = mobiletelephone;
        this.moneyType = moneyType;
        this.opEntrustWay = opEntrustWay;
        this.password = password;
        this.phonecode = phonecode;
        this.provinceNo = provinceNo;
        this.remark = remark;
        this.riskLevel = riskLevel;
        this.userId = userId;
        this.vocation = vocation;
        this.zipcode = zipcode;
    }

    private int functionId;

    // 用户编号（金融超市用户ID）
    private String userId;

    // 交易密码
    private String password;

    // 0-开户,1-增开交易帐户，默认为0
    private int actionIn;

    // 省份编号
    private String provinceNo;

    // 城市编号
    private String cityNo;

    // 证件类别:0-身份证
    private String idKind = "0";

    // 证件号码
    private String idNo;

    // 真实姓名
    private String clientName;

    // 邮政编码
    private String zipcode;

    // 联系地址
    private String address;

    // 联系电话
    private String phonecode;

    // 手机号码
    private String mobiletelephone;

    // 电子信箱
    private String eMail;

    // 职业
    private String vocation;

    // 学历
    private String eduLevel;

    // 年收入
    private BigDecimal income;

    // 币种类别
    private String moneyType = "0";

    // 风险等级
    private int riskLevel =0;

    // 备注
    private String remark;

    // 开户方式，默认网站开户
    private String opEntrustWay = CommonIn.OpEntrustWay_Web;

    /**
     * @return the functionId
     */
    public int getFunctionId() {
        return functionId;
    }

    /**
     * @param functionId
     *            the functionId to set
     */
    public void setFunctionId(int functionId) {
        this.functionId = functionId;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId
     *            the userId to set
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password
     *            the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the actionIn
     */
    public int getActionIn() {
        return actionIn;
    }

    /**
     * @param actionIn
     *            the actionIn to set
     */
    public void setActionIn(int actionIn) {
        this.actionIn = actionIn;
    }

    /**
     * @return the provinceNo
     */
    public String getProvinceNo() {
        return provinceNo;
    }

    /**
     * @param provinceNo
     *            the provinceNo to set
     */
    public void setProvinceNo(String provinceNo) {
        this.provinceNo = provinceNo;
    }

    /**
     * @return the cityNo
     */
    public String getCityNo() {
        return cityNo;
    }

    /**
     * @param cityNo
     *            the cityNo to set
     */
    public void setCityNo(String cityNo) {
        this.cityNo = cityNo;
    }

    /**
     * @return the idKind
     */
    public String getIdKind() {
        return idKind;
    }

    /**
     * @param idKind
     *            the idKind to set
     */
    public void setIdKind(String idKind) {
        this.idKind = idKind;
    }

    /**
     * @return the idNo
     */
    public String getIdNo() {
        return idNo;
    }

    /**
     * @param idNo
     *            the idNo to set
     */
    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    /**
     * @return the clientName
     */
    public String getClientName() {
        return clientName;
    }

    /**
     * @param clientName
     *            the clientName to set
     */
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    /**
     * @return the zipcode
     */
    public String getZipcode() {
        return zipcode;
    }

    /**
     * @param zipcode
     *            the zipcode to set
     */
    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    /**
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * @param address
     *            the address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * @return the phonecode
     */
    public String getPhonecode() {
        return phonecode;
    }

    /**
     * @param phonecode
     *            the phonecode to set
     */
    public void setPhonecode(String phonecode) {
        this.phonecode = phonecode;
    }

    /**
     * @return the mobiletelephone
     */
    public String getMobiletelephone() {
        return mobiletelephone;
    }

    /**
     * @param mobiletelephone
     *            the mobiletelephone to set
     */
    public void setMobiletelephone(String mobiletelephone) {
        this.mobiletelephone = mobiletelephone;
    }

    /**
     * @return the eMail
     */
    public String geteMail() {
        return eMail;
    }

    /**
     * @param eMail
     *            the eMail to set
     */
    public void seteMail(String eMail) {
        this.eMail = eMail;
    }

    /**
     * @return the vocation
     */
    public String getVocation() {
        return vocation;
    }

    /**
     * @param vocation
     *            the vocation to set
     */
    public void setVocation(String vocation) {
        this.vocation = vocation;
    }

    /**
     * @return the eduLevel
     */
    public String getEduLevel() {
        return eduLevel;
    }

    /**
     * @param eduLevel
     *            the eduLevel to set
     */
    public void setEduLevel(String eduLevel) {
        this.eduLevel = eduLevel;
    }

    /**
     * @return the income
     */
    public BigDecimal getIncome() {
        return income;
    }

    /**
     * @param income
     *            the income to set
     */
    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    /**
     * @return the moneyType
     */
    public String getMoneyType() {
        return moneyType;
    }

    /**
     * @param moneyType
     *            the moneyType to set
     */
    public void setMoneyType(String moneyType) {
        this.moneyType = moneyType;
    }

    /**
     * @return the riskLevel
     */
    public int getRiskLevel() {
        return riskLevel;
    }

    /**
     * @param riskLevel
     *            the riskLevel to set
     */
    public void setRiskLevel(int riskLevel) {
        this.riskLevel = riskLevel;
    }

    /**
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * @param remark
     *            the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOpEntrustWay() {
        return opEntrustWay;
    }

    public void setOpEntrustWay(String opEntrustWay) {
        this.opEntrustWay = opEntrustWay;
    }

    public String toString() {
        return ReflectionToStringBuilder.toStringExclude(this, "password");
    }

}
