package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 证联融通-线下充值流水查询(509/609) 9908
 * 
 * @author yyh
 * 
 */
public class OfflineRechargeQueryIn extends CommonIn {

	private static final long serialVersionUID = -5573115025776704468L;

	

	// (不需传，接口统一设置)商户的系统日期，YYYYMMDD
	private int fundDate;

	// (不需传，接口统一设置)商户的时间戳，HHMMSS
	private int fundTime;

	// 客户的姓名
	private String userNameText;

	// (不需传，接口统一设置)商户系统流水号。格式为 YYYYMMDD+509+序列，商户流水必须唯一
	private String fundSeqId;

	// 开始日期
	private int begLiqDate;

	// 结束日期
	private int endLiqDate;

	// 保留域，接收方必须原样回送该字段数据
	private String resv;

	//当前页
	private int currentPage;

	//每页大小
	private int pageSize;

	/**
	 * 00：余额充值 01：保证金充值 02:风险准备金充值
	 */
	private String businessType;


	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public int getBegLiqDate() {
		return begLiqDate;
	}

	public void setBegLiqDate(int begLiqDate) {
		this.begLiqDate = begLiqDate;
	}

	public int getEndLiqDate() {
		return endLiqDate;
	}

	public void setEndLiqDate(int endLiqDate) {
		this.endLiqDate = endLiqDate;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

	public int getCurrentPage() {
		return currentPage;
	}

	public void setCurrentPage(int currentPage) {
		this.currentPage = currentPage;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public String getBusinessType() {
		return businessType;
	}

	public void setBusinessType(String businessType) {
		this.businessType = businessType;
	}

}
