package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * 9907
 * 证联融通-线下充值通知(107/207)
 * @author yyh
 *
 */
public class OfflineRechargeIn extends CommonIn {

	private static final long serialVersionUID = 7974914045786971665L;

	
	private String password;

	//(不需填写，service统一处理) 商户的系统日期，YYYYMMDD
	private int fundDate;

	//(不需填写，service统一处理) 商户的时间戳，HHMMSS
	private int fundTime;

	// 客户的姓名
	private String userNameText;

	// 证件类型
	private String certType = "00";

	// 证件号码
	private String certId;

	//(不需填写，service统一处理) 商户系统流水号。格式为YYYYMMDD+107+序列，商户流水必须唯一
	private String fundSeqId;

	// 充值金额（以分为单位）
	private java.math.BigDecimal rechargeAmt;

	// 银行类别（收款行别）
	private String receibankCode;

	// 银行类别（付款行别）
	private String paymentbankCode;

	// 付款账户
	private String cardNo;

	// 付款账户名称
	private String cardName;

	// 保留域，接收方必须原样回送该字段数据
	private String resv = "resv";

	//00：余额充值 01：保证金充值 02:风险准备金充值
	private String businessType ;


	/**
	 * @return the businessType
	 */
	public String getBusinessType() {
		return businessType;
	}

	/**
	 * @param businessType the businessType to set
	 */
	public void setBusinessType(String businessType) {
		this.businessType = businessType;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getCertType() {
		return certType;
	}

	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getCertId() {
		return certId;
	}

	public void setCertId(String certId) {
		this.certId = certId;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public java.math.BigDecimal getRechargeAmt() {
		return rechargeAmt;
	}

	public void setRechargeAmt(java.math.BigDecimal rechargeAmt) {
		this.rechargeAmt = rechargeAmt;
	}

	public String getReceibankCode() {
		return receibankCode;
	}

	public void setReceibankCode(String receibankCode) {
		this.receibankCode = receibankCode;
	}

	public String getPaymentbankCode() {
		return paymentbankCode;
	}

	public void setPaymentbankCode(String paymentbankCode) {
		this.paymentbankCode = paymentbankCode;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public String getCardName() {
		return cardName;
	}

	public void setCardName(String cardName) {
		this.cardName = cardName;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

    @Override
    public String toString() {
        return "OfflineRechargeIn{" +
                "businessType='" + businessType + '\'' +
                ", password='" + password + '\'' +
                ", fundDate=" + fundDate +
                ", fundTime=" + fundTime +
                ", userNameText='" + userNameText + '\'' +
                ", certType='" + certType + '\'' +
                ", certId='" + certId + '\'' +
                ", fundSeqId='" + fundSeqId + '\'' +
                ", rechargeAmt=" + rechargeAmt +
                ", receibankCode='" + receibankCode + '\'' +
                ", paymentbankCode='" + paymentbankCode + '\'' +
                ", cardNo='" + cardNo + '\'' +
                ", cardName='" + cardName + '\'' +
                ", resv='" + resv + '\'' +
                ", userid='" + userId + '\'' +
                ", fundaccount='" + fundAccount + '\'' +
                '}';
    }
}
