/**
 *
 */
package com.ptteng.wealth.consign.model.in;

import java.io.Serializable;
import java.math.BigDecimal;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * 基金申购入参对象 function 9509
 *
 * @author 李春杰
 * @since 2012-11-20
 */
public class FundBuyIn implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 6579010857305900210L;


    // 系统功能
    private int functionId;

    // 金融超市用户ID
    private String userId;

    // 营业部号
    private Integer branchNo;

    // 交易账号
    private int fundAccount;

    //支付方式
    private String payType = "0";

    // 交易密码
    private String password;

    // 柜台密码
    private String gtFundPassword;

    // 基金公司，可不输入，不输入按基金代码找基金公司
    private String fundCompany;

    // 基金代码，必须输入基金代码，不支持内码。
    private String fundCode;

    // 金额
    private java.math.BigDecimal bankBalance;

    // 认购份数
    private java.math.BigDecimal amountT;

    // 银行代码
    private String bankNo;

    // 银行账号
    private String bankAccount;

    // 认购份数


    // 前后收费类型，0－前台，1－后台，可不输入，不输入按基金代销找收费类型。
    private String chargeType = "0";

    // 金融超市申请号
    private String outterSerialNo;

    // 委托方式, 默认全部
    private String opEntrustWay;

    // 备注
    private String remark;


    //支付方式：见BankTypeConstant 0-快捷，1-网关
    private String tiedCardType = "0";

    // 二级代码（超级活宝使用）
    private String secondCode;


    public int getFunctionId() {
        return functionId;
    }

    public void setFunctionId(int functionId) {
        this.functionId = functionId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Integer getBranchNo() {
        return branchNo;
    }

    public void setBranchNo(Integer branchNo) {
        this.branchNo = branchNo;
    }

    public int getFundAccount() {
        return fundAccount;
    }

    public void setFundAccount(int fundAccount) {
        this.fundAccount = fundAccount;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getGtFundPassword() {
        return gtFundPassword;
    }

    public void setGtFundPassword(String gtFundPassword) {
        this.gtFundPassword = gtFundPassword;
    }

    public String getFundCompany() {
        return fundCompany;
    }

    public void setFundCompany(String fundCompany) {
        this.fundCompany = fundCompany;
    }

    public String getFundCode() {
        return fundCode;
    }

    public void setFundCode(String fundCode) {
        this.fundCode = fundCode;
    }

    public BigDecimal getBankBalance() {
        return bankBalance;
    }

    public void setBankBalance(BigDecimal bankBalance) {
        this.bankBalance = bankBalance;
    }

    public BigDecimal getAmountT() {
        return amountT;
    }

    public void setAmountT(BigDecimal amountT) {
        this.amountT = amountT;
    }

    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getChargeType() {
        return chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public String getOutterSerialNo() {
        return outterSerialNo;
    }

    public void setOutterSerialNo(String outterSerialNo) {
        this.outterSerialNo = outterSerialNo;
    }

    public String getOpEntrustWay() {
        return opEntrustWay;
    }

    public void setOpEntrustWay(String opEntrustWay) {
        this.opEntrustWay = opEntrustWay;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * @return the tiedCardType
     */
    public String getTiedCardType() {
        return tiedCardType;
    }

    /**
     * @param tiedCardType the tiedCardType to set
     */
    public void setTiedCardType(String tiedCardType) {
        this.tiedCardType = tiedCardType;
    }

    public String getSecondCode() {
        return secondCode;
    }

    public void setSecondCode(String secondCode) {
        this.secondCode = secondCode;
    }

    public String toString() {
        return ReflectionToStringBuilder.toStringExclude(this, "password");
    }


}
