/**
 *
 */
package com.ptteng.wealth.consign.model.in;

import com.ptteng.wealth.consign.constant.FundChargeTypeConstant;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

import java.math.BigDecimal;

/**
 * 持仓滚存设置 (9963)
 *
 * @author yyh
 */
public class DeferIn extends CommonIn {

    private static final long serialVersionUID = -6356227851764889799L;

    public DeferIn(int branchNo, int functionId, int fundAccount, String opEntrustWay, String userId, String actionIn, String chargeType, String fundCode, String fundCompany, BigDecimal occurAmount, String outterSerialNo, String password) {
        super(branchNo, functionId, fundAccount, opEntrustWay, userId);
        this.actionIn = actionIn;
        this.chargeType = chargeType;
        this.fundCode = fundCode;
        this.fundCompany = fundCompany;
        this.occurAmount = occurAmount;
        this.outterSerialNo = outterSerialNo;
        this.password = password;
    }

    // 交易密码
    private String password;

    // 产品发行商
    private String fundCompany;

    // 产品代码
    private String fundCode;

    // 产品前后收费类型
    private String chargeType = FundChargeTypeConstant.BEFORE;

    // 滚存份数(预留，可不填)
    private java.math.BigDecimal occurAmount;

    // 金融超市申请号
    private String outterSerialNo;

    // 0 取消 1 设置
    private String actionIn;


    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFundCompany() {
        return fundCompany;
    }

    public void setFundCompany(String fundCompany) {
        this.fundCompany = fundCompany;
    }

    public String getFundCode() {
        return fundCode;
    }

    public void setFundCode(String fundCode) {
        this.fundCode = fundCode;
    }

    public String getChargeType() {
        return chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public java.math.BigDecimal getOccurAmount() {
        return occurAmount;
    }

    public void setOccurAmount(java.math.BigDecimal occurAmount) {
        this.occurAmount = occurAmount;
    }

    public String getOutterSerialNo() {
        return outterSerialNo;
    }

    public void setOutterSerialNo(String outterSerialNo) {
        this.outterSerialNo = outterSerialNo;
    }

    public String getActionIn() {
        return actionIn;
    }

    public void setActionIn(String actionIn) {
        this.actionIn = actionIn;
    }


    public String toString() {
        return ReflectionToStringBuilder.toStringExclude(this, new String[]{
                "password"});
    }

}
