/**
 * 
 */
package com.ptteng.wealth.consign.model.in;


import com.ptteng.wealth.consign.constant.FundChargeTypeConstant;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 金汇宝-收益流水查询 9984、9985
 * 
 * @author yyh
 * 
 */
public class CurrentIncomeRecordIn extends CommonIn{

	private static final long serialVersionUID = -184081663534265231L;
	

	// 金汇宝设立基金公司 可为null
	private String cashFundCompany;

	// 金汇宝基金代码 可为null
	private String cashFundCode;
	//前后收费类型 可为null
	private String cashChargeType = FundChargeTypeConstant.BEFORE;

	//收益类别，A0 基金分红 B0 酒产品收益 C0 项目投资收益
//	D0股权投资收益 D1股权经营收益  E0 提前赎回费用 E1 转让卖出费用
	private String incomeType;

	private int startDate;


	private int endDate;

	//请求记录数 （获取总数不使用）
	private int requestNum;

	//请求页数 （获取总数不使用）
	private int pageNo;



	public String getCashFundCompany() {
		return cashFundCompany;
	}



	public void setCashFundCompany(String cashFundCompany) {
		this.cashFundCompany = cashFundCompany;
	}



	public String getCashFundCode() {
		return cashFundCode;
	}



	public void setCashFundCode(String cashFundCode) {
		this.cashFundCode = cashFundCode;
	}



	public String getCashChargeType() {
		return cashChargeType;
	}



	public void setCashChargeType(String cashChargeType) {
		this.cashChargeType = cashChargeType;
	}



	public int getStartDate() {
		return startDate;
	}



	public void setStartDate(int startDate) {
		this.startDate = startDate;
	}



	public int getEndDate() {
		return endDate;
	}



	public void setEndDate(int endDate) {
		this.endDate = endDate;
	}



	public int getRequestNum() {
		return requestNum;
	}



	public void setRequestNum(int requestNum) {
		this.requestNum = requestNum;
	}



	public int getPageNo() {
		return pageNo;
	}



	public void setPageNo(int pageNo) {
		this.pageNo = pageNo;
	}



	public String getIncomeType() {
		return incomeType;
	}



	public void setIncomeType(String incomeType) {
		this.incomeType = incomeType;
	}



	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}
