package com.ptteng.wealth.consign.model.in;

import com.ptteng.wealth.user.model.User;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import java.io.Serializable;


public class CommonIn implements Serializable {


    private static final long serialVersionUID = -5430564473322604091L;

    /**
     * 网上站
     */
    public static final String OpEntrustWay_Web = "7";

    /**
     * 移动
     * @deprecated OpEntrustWay 相关常量请使用  OpEntrustWayEnum 枚举类
     */
    public static final String OpEntrustWay_Mobile = "8";

    /**
     * 线下
     */
    public static final String OpEntrustWay_Offline = "p";

    public CommonIn(){
        ;
    }
    public CommonIn(int branchNo, int functionId, int fundAccount, String opEntrustWay, String userId) {
        this.branchNo = branchNo;
        this.functionId = functionId;
        this.fundAccount = fundAccount;
        this.opEntrustWay = opEntrustWay;
        this.userId = userId;
    }

    /**
     * 所有
     */
    public static final String OpEntrustWay_ALL = "78p";


    /**
     * 系统功能
     */
    protected int functionId;

    /**
     * 金融超市账号
     */
    protected String userId;

    /**
     * 分支代码
     */
    protected int branchNo;

    /**
     * 资产账号
     */
    protected int fundAccount;

    /**
     * 委托方式,默认全部
     */
    protected String opEntrustWay;


    public void initUserInfo(User user){
        if(null == user ){
            return;
        }
        this.userId = String.valueOf(user.getId());
    }


    public String getOpEntrustWay() {
        return opEntrustWay;
    }


    public void setOpEntrustWay(String opEntrustWay) {
        this.opEntrustWay = opEntrustWay;
    }


    public int getFunctionId() {
        return functionId;
    }

    public void setFunctionId(int functionId) {
        this.functionId = functionId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getBranchNo() {
        return branchNo;
    }

    public void setBranchNo(int branchNo) {
        this.branchNo = branchNo;
    }

    public int getFundAccount() {
        return fundAccount;
    }

    public void setFundAccount(int fundAccount) {
        this.fundAccount = fundAccount;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }
}
