package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * 银行卡绑定
 * 
 * @author guozhixing
 * 
 */
public class CardBindingIn extends CommonIn {

	private static final long serialVersionUID = -3698108665229873102L;

	// 交易密码
	private String password;
	// 省份编号
	private String provinceNo;
	// 证件类型
	private String idKind;
	// 城市编号
	private String cityNo;
	// 证件号码
	private String idNo;
	// 姓名
	private String clientName;
	// 银行号
	private String bankNo;
	// 银行卡号
	private String bankAccount;
	// 备注
	private String remark;
	// 华创交易密码
	private String gtTradePassword;

	// 支付方式：见BankTypeConstant 0-快捷，1-网关 , 2-改密
	private String tiedCardType = "0";
	// 使用方式0 标准(直连银行)1 小额(银联)2手机验证
	private String useType;
	//手机验证码
	private String identifyingCode;
	//网站标示-用于配资回调
	private String channelResource;
	
	
	public String getChannelResource() {
		return channelResource;
	}

	public void setChannelResource(String channelResource) {
		this.channelResource = channelResource;
	}

	/**
	 * @return the identifyingCode
	 */
	public String getIdentifyingCode() {
		return identifyingCode;
	}

	/**
	 * @param identifyingCode the identifyingCode to set
	 */
	public void setIdentifyingCode(String identifyingCode) {
		this.identifyingCode = identifyingCode;
	}

	// 客户手机号
	private String phoneNo;
	// 0 普通银行卡开户，1 从小额改为标准直连银行（用 于提升额度），2 通过银行认证改密       默认为0
	private Integer actionIn = 0;

	/**
	 * @return the actionIn
	 */
	public Integer getActionIn() {
		return actionIn;
	}

	/**
	 * @param actionIn the actionIn to set
	 */
	public void setActionIn(Integer actionIn) {
		this.actionIn = actionIn;
	}

	public String getIdKind() {
		return idKind;
	}

	public void setIdKind(String idKind) {
		this.idKind = idKind;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getProvinceNo() {
		return provinceNo;
	}

	public void setProvinceNo(String provinceNo) {
		this.provinceNo = provinceNo;
	}

	public String getCityNo() {
		return cityNo;
	}

	public void setCityNo(String cityNo) {
		this.cityNo = cityNo;
	}

	public String getIdNo() {
		return idNo;
	}

	public void setIdNo(String idNo) {
		this.idNo = idNo;
	}

	public String getClientName() {
		return clientName;
	}

	public void setClientName(String clientName) {
		this.clientName = clientName;
	}

	public String getBankNo() {
		return bankNo;
	}

	public void setBankNo(String bankNo) {
		this.bankNo = bankNo;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	/**
	 * @return the tiedCardType
	 */
	public String getTiedCardType() {
		return tiedCardType;
	}

	/**
	 * @param tiedCardType
	 *            the tiedCardType to set
	 */
	public void setTiedCardType(String tiedCardType) {
		this.tiedCardType = tiedCardType;
	}

	public String getGtTradePassword() {
		return gtTradePassword;
	}

	public void setGtTradePassword(String gtTradePassword) {
		this.gtTradePassword = gtTradePassword;
	}

	public String getUseType() {
		return useType;
	}

	public void setUseType(String useType) {
		this.useType = useType;
	}

	public String getPhoneNo() {
		return phoneNo;
	}

	public void setPhoneNo(String phoneNo) {
		this.phoneNo = phoneNo;
	}

	public String toString() {
		return ReflectionToStringBuilder.toStringExclude(this, new String[] {});
	}
}
