package com.ptteng.wealth.consign.model.in;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 证联融通-余额流水查询输入 9905
 * 
 * @author yezhiwei
 * 2012-12-28
 */
public class CapitalFlowIn implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7666549158326395470L;

	/**
	 * 系统功能
	 */
	private int functionId;

	/**
	 * 金融超市账号
	 */
	private String userId;

	/**
	 * 分支代码
	 */
	private int branchNo;

	/**
	 * 资产账号
	 */
	private int fundAccount;

	/**
	 * 商户的系统日期，YYYYMMDD
	 */
	private int fundDate;

	/**
	 * 商户的时间戳，HHMMSS
	 */
	private int fundTime;

	/**
	 * 商户系统流水号。需要保证一个交易日中流水号的唯一性
	 */
	private String fundSeqId;

	/**
	 * 客户的姓名
	 */
	private String userNameText;

	/**
	 * 证件类型，参考附录
	 */
	private String certType;

	/**
	 * 证件号码
	 */
	private String certId;

	/**
	 * 当前页数
	 */
	private int currentPage;

	/**
	 * 当前页显示条数,如果查询全部数据，设置为-1
	 */
	private int pageSize;

	/**
	 * 开始日期
	 */
	private int startDate;

	/**
	 * 结束日期
	 */
	private int endDate;

	/**
	 * 保留域，接收方必须原样回送该字段数据
	 */
	private String resv;

	public int getFunctionId() {
		return functionId;
	}

	public void setFunctionId(int functionId) {
		this.functionId = functionId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public int getBranchNo() {
		return branchNo;
	}

	public void setBranchNo(int branchNo) {
		this.branchNo = branchNo;
	}

	public int getFundAccount() {
		return fundAccount;
	}

	public void setFundAccount(int fundAccount) {
		this.fundAccount = fundAccount;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public String getUserNameText() {
		return userNameText;
	}

	public void setUserNameText(String userNameText) {
		this.userNameText = userNameText;
	}

	public String getCertType() {
		return certType;
	}

	public void setCertType(String certType) {
		this.certType = certType;
	}

	public String getCertId() {
		return certId;
	}

	public void setCertId(String certId) {
		this.certId = certId;
	}

	public int getCurrentPage() {
		return currentPage;
	}

	public void setCurrentPage(int currentPage) {
		this.currentPage = currentPage;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public int getStartDate() {
		return startDate;
	}

	public void setStartDate(int startDate) {
		this.startDate = startDate;
	}

	public int getEndDate() {
		return endDate;
	}

	public void setEndDate(int endDate) {
		this.endDate = endDate;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}
