package com.ptteng.wealth.consign.model.in;


import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.IfQueryTransitmAmtEnum;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.out.CustomerInfo;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * 余额查询（9902）
 *
 * @author guozhixing
 */
public class BalanceInquiryIn extends CommonIn {
    private static final long serialVersionUID = 8529574292548800815L;

    public BalanceInquiryIn() {

    }

    public BalanceInquiryIn(int branchNo, int fundAccount, String opEntrustWay, String userId, String certId, String certType, int fundDate, String fundSeqId, int fundTime, String gtTradePassword, String password, String userNameText) {
        super(branchNo, 0, fundAccount, opEntrustWay, userId);
        this.certId = certId;
        this.certType = certType;
        this.fundDate = fundDate;
        this.fundSeqId = fundSeqId;
        this.fundTime = fundTime;
        this.gtTradePassword = gtTradePassword;
        this.password = password;
        this.userNameText = userNameText;
    }

    public BalanceInquiryIn(CustomerInfo customerInfo, String userId, String password, int fundDate, String fundSeqId, int fundTime, String gtTradePassword) {
        super(GlobalConstant.BRANCH_NO, 0, customerInfo.getFundAccount(), OpEntrustWayEnum.WEB.getValue(), userId);
        this.certId = customerInfo.getIdNo();
        this.certType = customerInfo.getIdKind();
        this.fundDate = fundDate;
        this.fundSeqId = fundSeqId;
        this.fundTime = fundTime;
        this.gtTradePassword = gtTradePassword;
        this.password = password;
        this.userNameText = customerInfo.getLastName();
    }

    // 交易密码
    private String password;
    // (不需填写，service统一处理) 商户的系统日期，YYYYMMDD
    private int fundDate;
    // (不需填写，service统一处理) 商户的时间戳，HHMMSS
    private int fundTime;
    // (不需填写，service统一处理) 商户系统流水号。需要保证一个交易日中流水号的唯一性
    private String fundSeqId;
    // 客户的姓名
    private String userNameText;
    // 证件类型，参考附录

    private String certType = "0";
    // 证件号码
    private String certId;
    // (不需填写，service统一处理) 保留域，接收方必须原样回送该字段数据
    private String resv = "resv";
    // 华创交易密码
    private String gtTradePassword;
    // 是否查询在途资金(0:不查询, 1:查询)
    private String ifQueryTransitmAmt = IfQueryTransitmAmtEnum.Allow_In_Transit.getValue();
    // 是否查询保证金和风险准备金(0:不查询,1:查询),默认不查询
    private String ifQueryRiskAmt;


    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getFundDate() {
        return fundDate;
    }

    public void setFundDate(int fundDate) {
        this.fundDate = fundDate;
    }

    public int getFundTime() {
        return fundTime;
    }

    public void setFundTime(int fundTime) {
        this.fundTime = fundTime;
    }

    public String getFundSeqId() {
        return fundSeqId;
    }

    public void setFundSeqId(String fundSeqId) {
        this.fundSeqId = fundSeqId;
    }

    public String getUserNameText() {
        return userNameText;
    }

    public void setUserNameText(String userNameText) {
        this.userNameText = userNameText;
    }

    public String getCertType() {
        return certType;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    public String getCertId() {
        return certId;
    }

    public void setCertId(String certId) {
        this.certId = certId;
    }

    public String getResv() {
        return resv;
    }

    public void setResv(String resv) {
        this.resv = resv;
    }

    public String getGtTradePassword() {
        return gtTradePassword;
    }

    public void setGtTradePassword(String gtTradePassword) {
        this.gtTradePassword = gtTradePassword;
    }

    public String toString() {
        return ReflectionToStringBuilder.toStringExclude(this, "password");
    }

    public String getIfQueryTransitmAmt() {
        return ifQueryTransitmAmt;
    }

    public String getIfQueryRiskAmt() {
        return ifQueryRiskAmt;
    }

    public void setIfQueryRiskAmt(String ifQueryRiskAmt) {
        this.ifQueryRiskAmt = ifQueryRiskAmt;
    }

    public void setIfQueryTransitmAmt(String ifQueryTransitmAmt) {
        this.ifQueryTransitmAmt = ifQueryTransitmAmt;
    }

}
