package com.ptteng.wealth.consign.model.in;

import com.ptteng.wealth.consign.constant.FundChargeTypeConstant;

import java.math.BigDecimal;

/**
 * @description : P2P配资贷保证金充值（9711）
 * 
 * @author 赵红军
 * 
 */
public class BailRechargeIn extends CommonIn {
	private static final long serialVersionUID = 1011420009632918563L;

	public BailRechargeIn(String password, String gtFundPassword, String opEntrustWay, String opBusinessFlag,
					  Integer actionIn, BigDecimal occurBalance, String bankNoDk, String bankAccountDk, String tiedCardType
	, BigDecimal bankBalance, String moneyType, String projectCode, String projectType, String payType, String channelResource){
		this.password = password;
		this.gtFundPassword = gtFundPassword;
		this.opEntrustWay = opEntrustWay;
		this.opBusinessFlag = opBusinessFlag;
		this.occurBalance = occurBalance;
		this.actionIn = actionIn;
		this.bankNoDk = bankNoDk;
		this.bankAccountDk = bankAccountDk;
		this.tiedCardType = tiedCardType;
		this.bankBalance = bankBalance;
		this.moneyType = moneyType;
		this.projectCode = projectCode;
		this.projectType = projectType;
		this.payType = payType;
		this.channelResource = channelResource;
	}


	/**
	 *  支付方式-银行卡
	 */
	public static final String PayType_Bank = "0";
	/**
	 *  支付方式-金汇宝
	 */
	public static final String PayType_Current = "4";
	/**
	 *  支付方式-金汇宝+银行卡
	 */
	public static final String PayType_Bank_Current = "5";
	
	/**
	 * funding_payment表planAmount
	 */
	private BigDecimal planAmount;

	/**
	 * funding_payment表id
	 */
	private BigDecimal fundingPaymentId;
	/**
	 * 业务种类
	 */
	private String businessType;

	/**
	 * 交易密码
	 */
	private String password;
	 /**
	  * 柜台资金密码
	  */
	private String gtFundPassword;
	/**
	  * 业务标志（8028 保证金充值）
	  */
	private String opBusinessFlag;
	/**
	 *  充值金额（总的保证金充值金额）
	 */
	private BigDecimal occurBalance;
	/**
	 *  代扣银行代码
	 */
	private String bankNoDk;
	/**
	 *  代扣银行账号
	 */
	private String bankAccountDk;
	/**
	 *  绑定类别,0 快捷绑卡1 网关绑卡
	 */
	private String tiedCardType;
	/**
	 *  银行卡代扣金额
	 */
	private BigDecimal bankBalance;
	/**
	 *  币种类别
	 */
	private String moneyType;
	/**
	 *  项目代码
	 */
	private String projectCode;
	/**
	 *  项目类别
	 */
	private String projectType;
	/**
	 *  基金公司（活宝）
	 */
	private String fundCompanyBack;
	/**
	 *  基金代码（活宝）
	 */
	private String fundCodeBack;
	/**
	 *  前后收费类型（活宝） 收费类型：0-前端，1-后端，2-混合
	 */
	private String chargeTypeBack = FundChargeTypeConstant.BEFORE;;
	/**
	 *  活宝使用份额
	 */
	private BigDecimal shareBack;
	/**
	 *  支付方式，0 银行卡；4 金汇宝；5 金汇宝+银
	 */
	private String payType;
	/**
	 *  渠道来源，配资平台：pz
	 */
	private String channelResource;

	/**
	 *  用户金汇宝 可用份额
	 */
	private BigDecimal userEnableShare;

	/**
	 *  用户金汇宝 可支付金额
	 */
	private BigDecimal userEnableBalance;

	/**
	 * 原项目代码，支付续约利息时传入
	 */
	private String projectCodeOld;

	/**
	 * 操作控制值，0缴纳保证金 1支付续约利息 2补充保证金
	 */
	private  int actionIn;

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getGtFundPassword() {
		return gtFundPassword;
	}

	public void setGtFundPassword(String gtFundPassword) {
		this.gtFundPassword = gtFundPassword;
	}

	public BigDecimal getOccurBalance() {
		return occurBalance;
	}

	public void setOccurBalance(BigDecimal occurBalance) {
		this.occurBalance = occurBalance;
	}

	public String getBankNoDk() {
		return bankNoDk;
	}

	public void setBankNoDk(String bankNoDk) {
		this.bankNoDk = bankNoDk;
	}

	public String getBankAccountDk() {
		return bankAccountDk;
	}

	public void setBankAccountDk(String bankAccountDk) {
		this.bankAccountDk = bankAccountDk;
	}

	public String getTiedCardType() {
		return tiedCardType;
	}

	public void setTiedCardType(String tiedCardType) {
		this.tiedCardType = tiedCardType;
	}

	public BigDecimal getBankBalance() {
		return bankBalance;
	}

	public void setBankBalance(BigDecimal bankBalance) {
		this.bankBalance = bankBalance;
	}

	public String getMoneyType() {
		return moneyType;
	}

	public void setMoneyType(String moneyType) {
		this.moneyType = moneyType;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectType() {
		return projectType;
	}

	public void setProjectType(String projectType) {
		this.projectType = projectType;
	}

	public String getFundCompanyBack() {
		return fundCompanyBack;
	}

	public void setFundCompanyBack(String fundCompanyBack) {
		this.fundCompanyBack = fundCompanyBack;
	}

	public String getFundCodeBack() {
		return fundCodeBack;
	}

	public void setFundCodeBack(String fundCodeBack) {
		this.fundCodeBack = fundCodeBack;
	}

	public String getChargeTypeBack() {
		return chargeTypeBack;
	}

	public void setChargeTypeBack(String chargeTypeBack) {
		this.chargeTypeBack = chargeTypeBack;
	}

	public BigDecimal getShareBack() {
		return shareBack;
	}

	public void setShareBack(BigDecimal shareBack) {
		this.shareBack = shareBack;
	}

	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	public String getOpBusinessFlag() {
		return opBusinessFlag;
	}

	public void setOpBusinessFlag(String opBusinessFlag) {
		this.opBusinessFlag = opBusinessFlag;
	}

	public String getChannelResource() {
		return channelResource;
	}

	public void setChannelResource(String channelResource) {
		this.channelResource = channelResource;
	}

	public BigDecimal getUserEnableShare() {
		return userEnableShare;
	}

	public void setUserEnableShare(BigDecimal userEnableShare) {
		this.userEnableShare = userEnableShare;
	}

	public BigDecimal getUserEnableBalance() {
		return userEnableBalance;
	}

	public void setUserEnableBalance(BigDecimal userEnableBalance) {
		this.userEnableBalance = userEnableBalance;
	}

	public String getBusinessType() {
		return businessType;
	}

	public void setBusinessType(String businessType) {
		this.businessType = businessType;
	}

	public BigDecimal getFundingPaymentId() {
		return fundingPaymentId;
	}

	public void setFundingPaymentId(BigDecimal fundingPaymentId) {
		this.fundingPaymentId = fundingPaymentId;
	}

	public String getProjectCodeOld() {
		return projectCodeOld;
	}

	public void setProjectCodeOld(String projectCodeOld) {
		this.projectCodeOld = projectCodeOld;
	}

	public int getActionIn() {
		return actionIn;
	}

	public void setActionIn(int actionIn) {
		this.actionIn = actionIn;
	}

	public BigDecimal getPlanAmount() {
		return planAmount;
	}

	public void setPlanAmount(BigDecimal planAmount) {
		this.planAmount = planAmount;
	}

}
