package com.ptteng.wealth.consign.model.in;


import java.math.BigDecimal;

import com.google.common.base.MoreObjects;
import com.ptteng.wealth.consign.constant.FundChargeTypeConstant;

/**
 * @description : 自动跟单保证金充值（9751）
 *
 * @author 赵红军
 *
 */
public class AutoDocBailRechargeIn extends CommonIn {
    /**
     *
     */
    private static final long serialVersionUID = -7854192175715813002L;
    /**
     *  支付方式-银行卡
     */
    public static final String PayType_Bank = "0";
    /**
     *  支付方式-金汇宝
     */
    public static final String PayType_Current = "4";
    /**
     *  支付方式-金汇宝+银行卡
     */
    public static final String PayType_Bank_Current = "5";

    /**
     * 跟单人资产账号
     */
    private int fundAccountG;

    /**
     * 交易密码
     */
    private String password;

    /**
     * 柜台资金密码
     */
    private String gtFundPassword;

    /**
     * 业务标志（8034 自动跟单保证金充值 8035 自动跟单保证金追加）
     */
    private String opbusinessFlag;

    /**
     *  跟单人充值或追加保证金金额
     */
    private java.math.BigDecimal occurBalanceG;

    /**
     * 被跟单人资产账号
     */
    private int fundAccountB;

    /**
     *  代扣银行代码
     */
    private String bankNoDk;
    /**
     *  代扣银行账号
     */
    private String bankAccountDk;
    /**
     *  绑定类别,0 快捷绑卡1 网关绑卡
     */
    private String tiedCardType;
    /**
     *  银行卡代扣金额
     */
    private java.math.BigDecimal bankBalance;
    /**
     *  币种类别
     */
    private String moneyType;
    /**
     *  虚拟基金公司
     */
    private String fundCompany;
    /**
     *  虚拟基金代码
     */
    private String fundCode;
    /**
     *  自动跟单保证金定位串
     */
    private String autotransNo;
    /**
     *  基金公司（活宝）
     */
    private String fundCompanyBack;
    /**
     *  基金代码（活宝）
     */
    private String fundCodeBack;
    /**
     *  前后收费类型（活宝） 收费类型：0-前端，1-后端，2-混合
     */
    private String chargeTypeBack = FundChargeTypeConstant.BEFORE;;
    /**
     *  活宝使用份额
     */
    private java.math.BigDecimal shareBack;
    /**
     *  用户金汇宝 可用份额
     */
    private BigDecimal userEnableShare;

    /**
     *  用户金汇宝 可支付金额
     */
    private BigDecimal userEnableBalance;
    /**
     *  支付方式，0 银行卡；4 金汇宝；5 金汇宝+银
     */
    private String payType;
    /**
     *  渠道来源，配资平台：gd
     */
    private String channelResource;
    /**
     *  表deposit：id
     */
    private long depositId;

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getGtFundPassword() {
        return gtFundPassword;
    }

    public void setGtFundPassword(String gtFundPassword) {
        this.gtFundPassword = gtFundPassword;
    }

    public String getBankNoDk() {
        return bankNoDk;
    }

    public void setBankNoDk(String bankNoDk) {
        this.bankNoDk = bankNoDk;
    }

    public String getBankAccountDk() {
        return bankAccountDk;
    }

    public void setBankAccountDk(String bankAccountDk) {
        this.bankAccountDk = bankAccountDk;
    }

    public String getTiedCardType() {
        return tiedCardType;
    }

    public void setTiedCardType(String tiedCardType) {
        this.tiedCardType = tiedCardType;
    }

    public java.math.BigDecimal getBankBalance() {
        return bankBalance;
    }

    public void setBankBalance(java.math.BigDecimal bankBalance) {
        this.bankBalance = bankBalance;
    }

    public String getMoneyType() {
        return moneyType;
    }

    public void setMoneyType(String moneyType) {
        this.moneyType = moneyType;
    }

    public String getFundCompanyBack() {
        return fundCompanyBack;
    }

    public void setFundCompanyBack(String fundCompanyBack) {
        this.fundCompanyBack = fundCompanyBack;
    }

    public String getFundCodeBack() {
        return fundCodeBack;
    }

    public void setFundCodeBack(String fundCodeBack) {
        this.fundCodeBack = fundCodeBack;
    }

    public String getChargeTypeBack() {
        return chargeTypeBack;
    }

    public void setChargeTypeBack(String chargeTypeBack) {
        this.chargeTypeBack = chargeTypeBack;
    }

    public java.math.BigDecimal getShareBack() {
        return shareBack;
    }

    public void setShareBack(java.math.BigDecimal shareBack) {
        this.shareBack = shareBack;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getChannelResource() {
        return channelResource;
    }

    public void setChannelResource(String channelResource) {
        this.channelResource = channelResource;
    }

    public int getFundAccountG() {
        return fundAccountG;
    }

    public void setFundAccountG(int fundAccountG) {
        this.fundAccountG = fundAccountG;
    }

    public java.math.BigDecimal getOccurBalanceG() {
        return occurBalanceG;
    }

    public void setOccurBalanceG(java.math.BigDecimal occurBalanceG) {
        this.occurBalanceG = occurBalanceG;
    }

    public int getFundAccountB() {
        return fundAccountB;
    }

    public void setFundAccountB(int fundAccountB) {
        this.fundAccountB = fundAccountB;
    }

    public String getFundCompany() {
        return fundCompany;
    }

    public void setFundCompany(String fundCompany) {
        this.fundCompany = fundCompany;
    }

    public String getFundCode() {
        return fundCode;
    }

    public void setFundCode(String fundCode) {
        this.fundCode = fundCode;
    }

    public BigDecimal getUserEnableShare() {
        return userEnableShare;
    }

    public void setUserEnableShare(BigDecimal userEnableShare) {
        this.userEnableShare = userEnableShare;
    }

    public BigDecimal getUserEnableBalance() {
        return userEnableBalance;
    }

    public void setUserEnableBalance(BigDecimal userEnableBalance) {
        this.userEnableBalance = userEnableBalance;
    }

    public String getOpbusinessFlag() {
        return opbusinessFlag;
    }

    public void setOpbusinessFlag(String opbusinessFlag) {
        this.opbusinessFlag = opbusinessFlag;
    }

    public String getAutotransNo() {
        return autotransNo;
    }

    public void setAutotransNo(String autotransNo) {
        this.autotransNo = autotransNo;
    }

    public long getDepositId() {
        return depositId;
    }

    public void setDepositId(long depositId) {
        this.depositId = depositId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("functionId", getFunctionId())
                .add("userId", getUserId())
                .add("branchNo", getBranchNo())
                .add("fundAccount", getFundAccount())
                .add("opEntrustWay", getOpEntrustWay())
                .add("fundAccountG", fundAccountG)
                .add("occurBalanceG", occurBalanceG)
                .add("opbusinessFlag", opbusinessFlag)
                .add("fundAccountB", fundAccountB).add("bankNoDk", bankNoDk)
                .add("tiedCardType", tiedCardType)
                .add("bankBalance", bankBalance).add("moneyType", moneyType)
                .add("autotransNo", autotransNo)
                .add("fundCompany", fundCompany)
                .add("fundCode", fundCode)
                .add("fundCompanyBack", fundCompanyBack)
                .add("fundCodeBack", fundCodeBack)
                .add("chargeTypeBack", chargeTypeBack)
                .add("shareBack", shareBack)
                .add("userEnableShare", userEnableShare)
                .add("userEnableBalance", userEnableBalance)
                .add("payType", payType)
                .add("channelResource", channelResource)
                .add("bankAccountDk", bankAccountDk)
                .add("depositId", depositId).toString();
    }
}
