package com.ptteng.wealth.consign.model.in;

import java.math.BigDecimal;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import com.ptteng.wealth.consign.constant.FundChargeTypeConstant;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

/**
 * @description : 自动跟单清算兑付（9752）
 * 
 * @author 赵红军
 * 
 */
public class AutoDocBailClearIn extends CommonIn {
	/**
	 * 
	 */
	private static final long serialVersionUID = 3353698673292609203L;

	/**
	 * 跟单人资产账号
	 */
	private int fundAccountG;
	
	/**
	 *  跟单人退回金额(三个总金额不能超过保证金)
	 */
	private BigDecimal occurBalanceG;
	
	/**
	 * 被跟单人资产账号
	 */
	private int fundAccountB;
	
	/**
	 *  被跟单人分成金额(三个总金额不能超过保证金)
	 */
	private BigDecimal occurBalanceB;
	
	/**
	 * 平台资金账号
	 */
	private int fundAccountC;
	
	/**
	 *  平台收取费用(三个总金额不能超过保证金)
	 */
	private BigDecimal occurBalanceC;
	
	/**
	 *  自动跟单保证金定位串
	 */
	private String autotransNo;
	
	public int getFundAccountG() {
		return fundAccountG;
	}

	public void setFundAccountG(int fundAccountG) {
		this.fundAccountG = fundAccountG;
	}

	public BigDecimal getOccurBalanceG() {
		return occurBalanceG;
	}
	
	public void setOccurBalanceG(BigDecimal occurBalanceG) {
		this.occurBalanceG = occurBalanceG;
	}
	
	public int getFundAccountB() {
		return fundAccountB;
	}
	
	public void setFundAccountB(int fundAccountB) {
		this.fundAccountB = fundAccountB;
	}
	
	public BigDecimal getOccurBalanceB() {
		return occurBalanceB;
	}
	
	public void setOccurBalanceB(BigDecimal occurBalanceB) {
		this.occurBalanceB = occurBalanceB;
	}
	
	public int getFundAccountC() {
		return fundAccountC;
	}

	public void setFundAccountC(int fundAccountC) {
		this.fundAccountC = fundAccountC;
	}

	public BigDecimal getOccurBalanceC() {
		return occurBalanceC;
	}

	public void setOccurBalanceC(BigDecimal occurBalanceC) {
		this.occurBalanceC = occurBalanceC;
	}
	
	public String getAutotransNo() {
		return autotransNo;
	}

	public void setAutotransNo(String autotransNo) {
		this.autotransNo = autotransNo;
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this)
				.add("functionId", getFunctionId())
				.add("userId", getUserId())
				.add("branchNo", getBranchNo())
				.add("fundAccount", getFundAccount())
				.add("opEntrustWay", getOpEntrustWay())
				.add("fundAccountG", fundAccountG)
				.add("occurBalanceG", occurBalanceG)
				.add("fundAccountB", fundAccountB)
				.add("occurBalanceB", occurBalanceB)				
				.add("fundAccountC", fundAccountC)
				.add("occurBalanceC", occurBalanceC)
				.add("autotransNo", autotransNo).toString();
	}
}
