package com.ptteng.wealth.consign.constant;



import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 用户风险等级常量
 *
 * @author yyh
 *
 */
public class UserRiskLevelConstant {

    /**
     * 保守型
     */
    public static final Integer LEVEL_0 = 0;
    /**
     * 稳健型
     */
    public static final Integer LEVEL_1 = 1;
    /**
     * 平衡型
     */
    public static final Integer LEVEL_2 = 2;
    /**
     * 成长型
     */
    public static final Integer LEVEL_3 = 3;
    /**
     * 激进型
     */
    public static final Integer LEVEL_4 = 4;


    private static final Map<Integer, String> riskLevelMap = new HashMap<Integer,String>() ;


    static {

        riskLevelMap.put(LEVEL_0, "保守型") ;
        riskLevelMap.put(LEVEL_1, "稳健型") ;
        riskLevelMap.put(LEVEL_2, "平衡型") ;
        riskLevelMap.put(LEVEL_3, "成长型") ;
        riskLevelMap.put(LEVEL_4, "激进型") ;

    }


    public static final Map<Integer, String> getRiskLevelMap() {
        return Collections.unmodifiableMap(riskLevelMap) ;
    }




}
