/**
 * 
 */
package com.ptteng.wealth.consign.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 产品类型, 接口字段 stock_type 对应新数据字典m_stock_type
 * 
 * @author 李春杰
 * @since 2012-11-15
 */
public class MStockTypeConstant {

	// 公募基金-非货币
	public static final String STOCK_TYPE_PUBLIC = "2";
	// 公募货币基金
	public static final String STOCK_TYPE_PUBLIC_CURRENCY = "3";

	// 集合理财产品-非货币
	public static final String STOCK_TYPE_BROKERS = "0";

	// 集合理财产品-货币
	public static final String STOCK_TYPE_BROKERS_CURRENCY = "1";
	// 券商固定收益
	public static final String STOCK_TYPE_BROKERS_FIXED_INCOME = "4";
	// 非券商固定收益
	public static final String STOCK_TYPE_NONBROKERS_FIXED_INCOME = "5";
	
	// 酒交所产品
	public static final String STOCK_TYPE_SPIRIT_FIXED_INCOME = "6";
	
	// 金汇活期宝
	public static final String STOCK_TYPE_CURRENT_INCOME = "8";
	
	// 爽活宝
	public static final String STOCK_TYPE_CJHB_INCOME = "y";
	
	// 新人宝
	public static final String STOCK_TYPE_CJHB_NEW_INCOME = "greenHands";
	
	// 股交所金融资产（项目投资）
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_FINANCIAL_ASSETS = "o";
	
	//平台债
	public static final String  STOCK_TYPE_EXCHANGE_STOCKS_GINKGO_ASSETS ="n";
	
	// 股交所股权资产(股权投资)
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_EQUITY_ASSETS = "p";

	// 股交所股权资产(OTC)
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_OTC_ASSETS = "t";
	
	// 股交所产品(信托产品)
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_TRUSTPRO_ASSETS = "u";

	// 股交所产品(私募优选)
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_PRIVATE_ASSETS = "v";

	// 股交所产品(同航网p2p)
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_P2P_THW_ASSETS = "x";
	
	// 股交所产品(首付贷p2p)
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_P2P_DPL_ASSETS = "q";
	
	// 金汇金融产品(质押贷p2p)
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_P2P_PLEDGE_ASSETS = "z";
	
	// 配资
	public static final String STOCK_TYPE_WITH_FUNDING = "r";
	
	/**
	 *  股交所产品(至尊分享)
	 */
	public static final String STOCK_TYPE_EXCHANGE_STOCKS_HONOR_SHARE = "w";
		
	
	/**
	 * 全部类型的基金
	 */
	public static final int all = -1;
//
//	/**
//	 * 公募-货币型基金
//	 */
//	public static final int PUBLIC_CURRENCY = 3;
//	/**
//	 * 公募-非货币型基金
//	 */
//	public static final int PUBLIC_OPEN = 2;
//	/**
//	 * 券商集合理财-货币型基金
//	 */
//	public static final int BROKERS_CURRENCY = 1;
//	/**
//	 * 券商集合理财-非货币型基金
//	 */
//	public static final int BROKERS_OPEN = 0;
//
//	// 券商固定收益
//	public static final int BROKERS_FIXED_INCOME = 4;
//	// 非券商固定收益
//	public static final int NONBROKERS_FIXED_INCOME = 5;
//	// 酒交所产品
//	public static final int SPIRIT_FIXED_INCOME = 6;
		

	/**
	 * 股票型基金
	 */
	public static final String ZL_TYPE_PUBLIC_00 = "00";
	/**
	 * 货币型基金
	 */
	public static final String ZL_TYPE_PUBLIC_01 = "01";
	/**
	 * 债券型基金
	 */
	public static final String ZL_TYPE_PUBLIC_02 = "02";
	/**
	 * 混合型基金
	 */
	public static final String ZL_TYPE_PUBLIC_03 = "03";
	/**
	 * 保本型基金
	 */
	public static final String ZL_TYPE_PUBLIC_04 = "04";
	/**
	 * 指数型基金
	 */
	public static final String ZL_TYPE_PUBLIC_05 = "05";
	/**
	 * QDII型基金
	 */
	public static final String ZL_TYPE_PUBLIC_06 = "06";
	/**
	 * ETF型基金
	 */
	public static final String ZL_TYPE_PUBLIC_07 = "07";
	/**
	 * LOF型基金
	 */
	public static final String ZL_TYPE_PUBLIC_08 = "08";
	/**
	 * 创新型基金
	 */
	public static final String ZL_TYPE_PUBLIC_09 = "09";
	/**
	 * 其他
	 */
	public static final String ZL_TYPE_PUBLIC_10 = "10";
	// 全部
	public static final String STOCK_TYPE_ALL = "!";

	private static final HashMap<String, String> fundTypeMap = new HashMap<String, String>();
	
	private static final Map<String, String> fixTypeMap = new HashMap<String, String>();

	private static final List<String> fixTypeList = new ArrayList<String>();
	
	private static final HashMap<String,String> fundTypeNameMap = new HashMap<String,String>();
	
	static {
		fundTypeMap.put(STOCK_TYPE_PUBLIC_CURRENCY, "public");
		fundTypeMap.put(STOCK_TYPE_PUBLIC, "public");
		fundTypeMap.put(STOCK_TYPE_CURRENT_INCOME, "public");
		fundTypeMap.put(STOCK_TYPE_BROKERS_CURRENCY, "brokers");
		fundTypeMap.put(STOCK_TYPE_BROKERS, "brokers");
		fundTypeMap.put(STOCK_TYPE_SPIRIT_FIXED_INCOME, "spirit");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_FINANCIAL_ASSETS, "project");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_EQUITY_ASSETS, "equity");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_OTC_ASSETS, "otc");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_TRUSTPRO_ASSETS, "trustpro");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_PRIVATE_ASSETS, "private");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_P2P_THW_ASSETS, "p2p");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_P2P_DPL_ASSETS, "p2p");
		fundTypeMap.put(STOCK_TYPE_WITH_FUNDING, "p2p");
		fundTypeMap.put(STOCK_TYPE_EXCHANGE_STOCKS_HONOR_SHARE, "honor");
		
		fixTypeMap.put("project", STOCK_TYPE_EXCHANGE_STOCKS_FINANCIAL_ASSETS);
		fixTypeMap.put("equity", STOCK_TYPE_EXCHANGE_STOCKS_EQUITY_ASSETS);
		fixTypeMap.put("spirit", STOCK_TYPE_SPIRIT_FIXED_INCOME);
		fixTypeMap.put("otc", STOCK_TYPE_EXCHANGE_STOCKS_OTC_ASSETS);
		fixTypeMap.put("trustpro", STOCK_TYPE_EXCHANGE_STOCKS_TRUSTPRO_ASSETS);
		fixTypeMap.put("private", STOCK_TYPE_EXCHANGE_STOCKS_PRIVATE_ASSETS);
		fixTypeMap.put("p2p", STOCK_TYPE_EXCHANGE_STOCKS_P2P_THW_ASSETS);
		fixTypeMap.put("honor", STOCK_TYPE_EXCHANGE_STOCKS_HONOR_SHARE);
		
		fixTypeList.add(STOCK_TYPE_SPIRIT_FIXED_INCOME);
		fixTypeList.add(STOCK_TYPE_BROKERS_FIXED_INCOME);
		fixTypeList.add(STOCK_TYPE_NONBROKERS_FIXED_INCOME);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_FINANCIAL_ASSETS);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_EQUITY_ASSETS);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_OTC_ASSETS);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_TRUSTPRO_ASSETS);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_PRIVATE_ASSETS);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_P2P_THW_ASSETS);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_P2P_DPL_ASSETS);
		fixTypeList.add(STOCK_TYPE_WITH_FUNDING);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_HONOR_SHARE);
		fixTypeList.add(STOCK_TYPE_EXCHANGE_STOCKS_GINKGO_ASSETS);
		
		fundTypeNameMap.put("m", "金汇宝");
		fundTypeNameMap.put(STOCK_TYPE_EXCHANGE_STOCKS_HONOR_SHARE, "理财分享");
		fundTypeNameMap.put(STOCK_TYPE_EXCHANGE_STOCKS_FINANCIAL_ASSETS, "银杏系列");
		fundTypeNameMap.put(STOCK_TYPE_EXCHANGE_STOCKS_OTC_ASSETS, "资管计划");
		fundTypeNameMap.put(STOCK_TYPE_EXCHANGE_STOCKS_TRUSTPRO_ASSETS, "信托计划");
		fundTypeNameMap.put(STOCK_TYPE_EXCHANGE_STOCKS_PRIVATE_ASSETS, "收益凭证");
		fundTypeNameMap.put(STOCK_TYPE_EXCHANGE_STOCKS_GINKGO_ASSETS, "地方债");
		fundTypeNameMap.put(STOCK_TYPE_CJHB_INCOME, "爽活宝");
		/*fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");
		fundTypeNameMap.put(, "");*/
		
	}
	
	

	public static Map<String, String> getFixtypemap() {
		return fixTypeMap;
	}

	public static List<String> getFixtypelist() {
		return fixTypeList;
	}
	
	/**
	 * @return the fundtypenamemap
	 */
	public static HashMap<String, String> getFundtypenamemap() {
		return fundTypeNameMap;
	}

	/**
	 * 根据stockType取category的映射值
	 * 
	 * @param stockType
	 *            代销系统的
	 * @return
	 */
	public static String getFixStockTypeByCategory(String category) {
		if (null == fixTypeMap.get(category)) {
			return "";
		}
		return (String) fixTypeMap.get(category);
	}

	/**
	 * 根据stockType取category的映射值
	 * 
	 * @param stockType
	 *            代销系统的
	 * @return
	 */
	public static String getCategoryByStockType(String stockType) {
		if (null == fundTypeMap.get(stockType)) {
			return "";
		}
		return (String) fundTypeMap.get(stockType);
	}

	/**
	 * @return the fundtypemap
	 */
	public static Map getFundtypemap() {
		return fundTypeMap;
	}

	public static Map<String, String> zlFundTypeMap = new HashMap<String, String>();

	static {
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_00, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_01, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_02, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_03, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_04, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_05, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_06, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_07, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_08, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_09, "public");
		zlFundTypeMap.put(ZL_TYPE_PUBLIC_10, "brokers");
	}

	public static Map<String, String> getZlFundTypeMap() {
		return zlFundTypeMap;
	}

}
