/**
 *
 */
package com.ptteng.wealth.consign.constant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 基金风险等级常量
 *
 * @author 李春杰
 * @since 2012-11-15
 */
public class FundRiskLevelConstant {

    /**
     * 低风险
     */
    public static final String DEFAULT = "0";
    /**
     * 中低风险
     */
    public static final String CAPITAL_GUARANTEED = "1";
    /**
     * 中风险
     */
    public static final String LOW = "2";
    /**
     * 中高风险
     */
    public static final String MEDIUM = "3";
    /**
     * 高风险
     */
    public static final String HIGH = "4";


    private static final Map<String, String> riskLevelMap = new HashMap<String, String>();


    static {

        riskLevelMap.put(DEFAULT, "低风险");
        riskLevelMap.put(CAPITAL_GUARANTEED, "中低风险");
        riskLevelMap.put(LOW, "中风险");
        riskLevelMap.put(MEDIUM, "中高风险");
        riskLevelMap.put(HIGH, "高风险");

    }


    public static final Map<String, String> getRiskLevelMap() {
        return Collections.unmodifiableMap(riskLevelMap);
    }

}
