/**
 * 
 */
package com.ptteng.wealth.consign.constant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 业务标志/交易类型
 * 
 * @author 李春杰
 * @since 2012-11-16
 */
public class FundOPBusinessFlagConstant {

	/**
	 * 认购
	 */
	public static final Integer SUBSCRIBE = 20;
	/**
	 * 申购
	 */
	public static final Integer BUY = 22;
	/**
	 * 赎回
	 */
	public static final Integer REDEMPTION = 24;
	/**
	 * 修改分红方式
	 */
	public static final Integer MODIFY_BONUS = 29;
	/**
	 * 转换
	 */
	public static final Integer TRANSFORM = 36;
	/**
	 * 定期定额申购
	 */
	public static final Integer REGULAR_FIXED_BUY = 39;
	/**
	 * 撤单
	 */
	public static final Integer CANCEL = 52;
	/**
	 * 撤单
	 */
	public static final Integer CANCELT = 53;
	/**
	 * 定期定额申购协议签订
	 */
	public static final Integer REGULAR_FIXED_SIGN_AGREEMENT = 59;
	/**
	 * 定期定额申购协议取消
	 */
	public static final Integer REGULAR_FIXED_CANCEL_AGREEMENT = 60;
	/**
	 * 定期定额申购协议修改
	 */
	public static final Integer REGULAR_FIXED_MODIFY_AGREEMENT = 61;
	/**
	 * 分红
	 */
	public static final Integer BONUS = 143;

	/**
	 * 金汇宝充值(转入)
	 */
	public static final String Current_Recharge = "222";
	/**
	 * 金汇宝提现(转出)
	 */
	public static final String Current_Withdraw = "224";
	

	/**
	 * 转让卖出标识(提前赎回)
	 */
	public static final String Spirit_Early_Redeem = "8004";


	//金汇活宝充值
	public static final int recharge = 222;
	//金汇活宝提现
    public static final int withdraw = 224;
    //普通提现日终后的交易记录
    public static final int withdraw2 = 124;
    
    //爽活宝快提
    public static final int withdraw_shb = 229;
    
    //提酒
    public static final int redeem = 8001;
	/**
	 * 转让卖出标识(提前赎回)（做市商）
	 */
	public static final int Early_Redeem = 8004;
	
	/**
	 * 受让买入(提前赎回)（做市商）
	 */
	public static final int Early_Redeem_Buy = 8005;
    
	
	
	/**
	 * 提前赎回卖出（滚存）
	 */
	public static final int Early_Redeem_Retained = 8006;
	
	/**
	 * 提前赎回买入（滚存）
	 */
	public static final int Early_Redeem_Retained_Buy = 8007;
	
	/**
	 * 转让交易(卖出)
	 */
	public static final int Early_TransDeal_Sellout = 8010;

	/**
	 * 转让交易(买入)
	 */
	public static final int Early_TransDeal_Buy_In = 8011;
    
	//酒产品兑付申购
    public static final int Spirit_Cash_Buy = 226;
    
    //酒产品兑付赎回
    public static final int Spirit_Cash_Redemption = 227;
    
    /**
	 * 首付贷(买入)
	 */
	public static final int Early_Dpl_Buy_In = 8016;
	
	  /**
	 * 首付贷(还款)
	 */
	public static final int Early_Dpl_Repay_In = 8017;
	
	/**
	 * 首付贷(分期兑付)
	 */
	public static final int Early_Dpl_Repay_Term = 8020;
	
	/**
	 * 配资实时退款
	 */
	public static final int Early_Pz_Drawback_Now = 8021;
	
	/**
	 * 首付贷(逾期还款)
	 */
	public static final int Early_Dpl_Expiry_Repay_In = 8022;	
	
	/**
	 * 配资退款
	 */
	public static final int Early_Pz_Drawback = 40;
	
    /**
	 * 交易记录业务类型
	 */
	private static final Map<Integer, String> recordType = new HashMap<Integer, String>();
	static {
		recordType.put(SUBSCRIBE, "购买");
		recordType.put(BUY, "购买");
		recordType.put(recharge, "购买");
		recordType.put(withdraw, "快速提现");
		recordType.put(withdraw_shb, "快速提现");
		recordType.put(withdraw2, "普通提现");
		recordType.put(REDEMPTION, "普通提现");
		recordType.put(Early_Redeem_Buy, "受让买入");
		recordType.put(Early_Redeem_Retained, "提前赎回卖出");
		recordType.put(Early_Redeem_Retained_Buy, "提前赎回买入");
		//recordType.put(REDEMPTION, "兑付");
		recordType.put(redeem, "提酒");
		recordType.put(Spirit_Cash_Buy, "兑付");
		recordType.put(Spirit_Cash_Redemption, "兑付");
		recordType.put(Early_Redeem, "转让");
		recordType.put(Early_TransDeal_Buy_In, "转让买入");
		recordType.put(Early_TransDeal_Sellout, "转让卖出");
		recordType.put(Early_Dpl_Buy_In, "购买");
		recordType.put(Early_Dpl_Repay_In, "还款");
		recordType.put(Early_Dpl_Repay_Term, "分期兑付");
		recordType.put(Early_Dpl_Expiry_Repay_In, "逾期还款");
		recordType.put(Early_Pz_Drawback_Now, "退款");
		recordType.put(Early_Pz_Drawback, "退款");
		//recordType.put(REDEMPTION, "赎回");
		recordType.put(CANCEL, "撤单");
		
	}

	public static Map<Integer, String> getRecordType() {
		return recordType;
	}
	
	public static final List<Integer> buyBusinessFlag = Arrays.asList(new Integer[]{SUBSCRIBE,BUY,recharge,Early_TransDeal_Buy_In,Early_Dpl_Buy_In});
	
	

}
