/**
 * 
 */
package com.ptteng.wealth.consign.constant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 基金收费方式
 * 
 * @author 李春杰
 * @since  2012-11-15
 */
public class FundChargeTypeConstant {
	
	/**
	 * 前端收费 
	 */
	public static final String BEFORE = "0" ;
	/**
	 * 后端收费
	 */
	public static final String BACK = "1" ;
	/**
	 * 混合收费 
	 */
	public static final String MIX = "2" ;
	
	
	private static final Map<String,String> chargeTypeMap = new HashMap<String,String>() ;
	
	static {
		chargeTypeMap.put(BEFORE, "前端收费") ;
		chargeTypeMap.put(BACK, "后端收费") ;
		chargeTypeMap.put(MIX, "混合收费 ") ;
	}
	
	public static final Map<String,String> getChargeTypeMap() {
		return Collections.unmodifiableMap(chargeTypeMap) ;
	}
}
