package com.ptteng.wealth.consign.constant;

/**
 * 
 * @ClassName: BusinessTypeEnum 
 * @Description: 证联融通-资金调拨
 * @author ykwang 
 * @date 2015-5-18 上午10:21:17 
 *
 */
public enum BusinessTypeEnum {
	
	// 线上充值
	/**
	 * 余额划拨到风险准备金
	 */
	BALANCE_RISKAMT("00"),
	/**
	 * 余额划拨到保证金
	 */
	BALANCE_SURETYAMT("01"), 
	/**
	 * 风险准备金划拨到余额
	 */
	RISKAMT_BALANCE("02"),	
	/**
	 * 保证金划拨到余额
	 */
	SURETYAMT_BALANCE("03"),
	
	
	
	//线下充值
	/**
	 * 余额充值
	 */
	BALANCE_RECHARGE("00"),	
	/**
	 * 保证金充值
	 */
	SURETYAMT_RECHARGE("01"), 
	/**
	 * 风险准备金充值
	 */
	RISKAMT_RECHARGE("02");	
	
	private final String value ;

	BusinessTypeEnum(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}
	
}
