/**
 *
 */
package com.ptteng.wealth.consign.client;

import java.util.List;
import java.util.Map;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.wealth.user.model.User;
import org.osoa.sca.annotations.Reference;

public class ConsignSCAClient implements ConsignmentService{

    private ConsignmentService consignmentService;

    public ConsignmentService getConsignmentService() {
        return consignmentService;
    }


    @Reference
    public void setConsignmentService(ConsignmentService consignmentService) {
        this.consignmentService =consignmentService;
    }



    @Override
    public OpenAccountOut openAccount(OpenAccountIn in)throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.openAccount(in);


    }


    @Override
    public CustomerInfo getCustomerInfo(String userId) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.getCustomerInfo(userId);


    }


    @Override
    public List<BindingBank> getBanks(int fundAccount, String userId) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getBanks(fundAccount,userId);


    }


    @Override
    public List<BindingBank> getBindingBanks(BindingBankIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getBindingBanks(in);


    }


    @Override
    public CardBindingOut cardBinding(CardBindingIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.cardBinding(in);


    }


    @Override
    public CommonOut modifyTransactionPassword(TransactionPasswordIn tpi) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.modifyTransactionPassword(tpi);


    }


    @Override
    public CommonOut retrieveTransactionPassword(RetrieveTransactionPasswordIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.retrieveTransactionPassword(in);


    }




    @Override
    public OpenAccountOut openOrgan(OrganOpenAccountIn in) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.openOrgan(in);


    }


    @Override
    public CardBindingOut orgBindcard(OrganBindCardIn in) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.orgBindcard(in);


    }


    @Override
    public OrganInfo getOrganInfo(OrganInfoIn organInfoIn) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getOrganInfo(organInfoIn);


    }


    @Override
    public CancelCardOut cancelCard(CancelCardIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.cancelCard(in);


    }


    @Override
    public CommonOut modifyAccountInfo(AccountInfoIn ai) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.modifyAccountInfo(ai);


    }


    @Override
    public CommonOut modifyPersonalInfo(PersonalInfoIn pii) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.modifyPersonalInfo(pii);


    }


    @Override
    public RiskLevelModifyOut modifyRiskLevel(RiskLevelModifyIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.modifyRiskLevel(in);


    }




    @Override
    public WithdrawLimitOut getWithdrawLimit(WithdrawLimitIn in) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.getWithdrawLimit(in);


    }


    @Override
    public RechargeOut recharge(RechargeIn ri) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.recharge(ri);


    }


    @Override
    public RechargeOut rechargeGateway(RechargeIn ri) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.rechargeGateway(ri);


    }


    @Override
    public WithdrawCashOut withdraw(WithdrawCashIn wc) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.withdraw(wc);


    }


    @Override
    public OfflineRechargeOut rechargeOffline(OfflineRechargeIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.rechargeOffline(in);


    }


    @Override
    public BailRechargeOut bailRecharge(BailRechargeIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.bailRecharge(in);


    }


    @Override
    public MainCardOut setMainCard(MainCardIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.setMainCard(in);


    }


    @Override
    public List<OfflineRecharge> getRechargeOfflineRecord(OfflineRechargeQueryIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getRechargeOfflineRecord(in);


    }


    @Override
    public List<SpiritPosition> getSpiritPosition(SpiritPositionIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getSpiritPosition(in);


    }




    @Override
    public SpiritPositionStat getSpiritPositionStat(SpiritPositionStatIn in) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.getSpiritPositionStat(in);


    }


    @Override
    public Position getPosition(PositionIn in) throws Exception,ServiceException, ServiceDaoException{

        return consignmentService.getPosition(in);


    }


    @Override
    public RedeemOut redeem(RedeemIn ri) throws Exception{

        return consignmentService.redeem(ri);


    }

    @Override
    public List<UncomeBalanceRecord> getUncomeBalanceRecord(UncomeBalanceIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getUncomeBalanceRecord(in);


    }


    @Override
    public CommonOut setUpDefer(DeferIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.setUpDefer(in);


    }

    @Override
    public FundBuyOut buyFund(FundBuyIn fundBuyIn, String mobile) throws Exception{

        return consignmentService.buyFund(fundBuyIn, mobile);

    };

    @Override
    public List<CurrentPositionStat> getCurrentPositionStat(CurrentPositionStatIn in) throws Exception{

        return consignmentService.getCurrentPositionStat(in);

    };


    @Override
    public List<CurrentIncomeRecord> getCurrentIncomeRecord(CurrentIncomeRecordIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getCurrentIncomeRecord(in);


    }


    @Override
    public Integer getCurrentIncomeRecordCount(CurrentIncomeRecordIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getCurrentIncomeRecordCount(in);


    }


    @Override
    public List<LoanInfoOut> getLoanInfo(LoanInfoIn in) throws Exception , ServiceException, ServiceDaoException {

        return consignmentService.getLoanInfo(in);

    }





    @Override
    public RepaymentPlanStatOut getRepaymentPlanStat(RepaymentPlanStatIn in) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.getRepaymentPlanStat(in);


    }


    @Override
    public List<RepaymentPlanOut> getRepaymentPlan(RepaymentPlanIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getRepaymentPlan(in);


    }


    @Override
    public BalanceInquiryOut getBalance(BalanceInquiryIn bii) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getBalance(bii);


    }


    @Override
    public List<RechargeWaterQueryOut> getRechargeWaterQuery(RechargeWaterQueryIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getRechargeWaterQuery(in);


    }


    @Override
    public List<WithdrawWaterQueryOut> getWithdrawWaterQuery(WithdrawWaterQueryIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getWithdrawWaterQuery(in);


    }


    @Override
    public List<CapitalFlowOut> getCapitalFlows(CapitalFlowIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getCapitalFlows(in);


    }




    @Override
    public TransactionRecordCountOut getRecordCount(TransactionRecordCountIn trci) throws Exception ,ServiceException, ServiceDaoException{

        return consignmentService.getRecordCount(trci);


    }


    @Override
    public TransferCapitalOut getTransferCapital(TransferCapitalIn in)  throws Exception,ServiceException, ServiceDaoException{

        return consignmentService.getTransferCapital(in);


    }


    @Override
    public MessageAuthenticationCodeOut getMessageCode(MessageAuthenticationCodeIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getMessageCode(in);


    }


    @Override
    public LoanInfoStatOut getLoanInfoStat(LoanInfoStatIn in) throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getLoanInfoStat(in);


    }


    @Override
    public LoanMoneyStatOut getLoanMoneyStat(LoanMoneyStatIn loanMoneyStatIn)  throws Exception , ServiceException, ServiceDaoException{

        return consignmentService.getLoanMoneyStat(loanMoneyStatIn);


    }


    @Override
    public SuretyDepositStatOut getSuretyDepositStat(SuretyDepositStatIn in)  throws Exception, ServiceException, ServiceDaoException{

        return consignmentService.getSuretyDepositStat(in);


    }

    @Override
    public List<TransactionRecordQueryOut> queryRecord(TransactionRecordQueryIn trqi) throws Exception{

        return consignmentService.queryRecord(trqi);

    };


    @Override
    public CommonOut insertSpiritDelivery(SpiritDeliveryIn in) throws Exception , ServiceException, ServiceDaoException {

        return consignmentService.insertSpiritDelivery(in);

    }

    @Override
    public Map<String, FixPosition> getFixPosition(CommonIn in) throws Exception {
        return  consignmentService.getFixPosition(in);
    }

    @Override
    public List<SpiritDelivery> querySpiritDelivery(SpiritDeliveryQueryIn in) throws Exception {
        return consignmentService.querySpiritDelivery(in);
    }

    @Override
    public List<BindingBank> getCardsByType(int fundAccount, String userId, List<String> bankTypeList) throws Exception {
        return consignmentService.getCardsByType(fundAccount, userId, bankTypeList);
    }

    @Override
    public SpiritBuyOut buySpirit(SpiritBuyIn in) throws Exception {
        return  consignmentService.buySpirit(in);
    }

    @Override
    public AutoDocBailRechargeOut autoDocBailRecharge(AutoDocBailRechargeIn in) throws Exception {
        return  consignmentService.autoDocBailRecharge(in);
    }

    @Override
    public IncreaseLevelOfCreditOut increaseLevelOfCreditOut(IncreaseLevelOfCreditIn in) throws Exception {
        return  consignmentService.increaseLevelOfCreditOut(in);
    }

    @Override
    public AutoDocBailClearOut autoDocBailClear(AutoDocBailClearIn in) throws Exception {
        return  consignmentService.autoDocBailClear(in);
    }
}

