package com.ptteng.wealth.admin.controller;

import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.admin.model.Constant;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.DebtConstant;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.finance.model.Bank;
import com.ptteng.wealth.finance.service.BankService;
import com.ptteng.wealth.user.model.User;
import com.qding.common.util.DataUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.util.*;

/**
 * Invest  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BankLimitController extends BaseController{
    private static final Log log = LogFactory.getLog("bank_limit");

    @Autowired
    private BankService bankService;
    @Autowired
    private ManagerService managerService;


    /**
     * 银行列表
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/bank/search", method = RequestMethod.GET)
    public String getTransactIdsByUserIdJsonList(HttpServletRequest request,
                                                 HttpServletResponse response, ModelMap model, Integer page,
                                                 Integer size,String bankName,String createName,
                                                 Long startAt,Long endAt,String minSingleQuota,String maxSingleQuota,
                                                 String minDailyQuota,String maxDailyQuota) throws Exception {
        log.info(" get bank list , bankName = "+bankName+" createName = "+createName+" startAt ="+
                startAt+" endAt = "+endAt+" minSingleQuota = "+minSingleQuota+" maxSingleQuota = "+maxSingleQuota+"" +
                " minDailyQuota = "+minDailyQuota+" maxDailyQuota = "+maxDailyQuota);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {


            Map<String,Object> map = DynamicUtil.getBankList(bankName,createName,startAt,endAt,minSingleQuota,
                    maxSingleQuota,minDailyQuota,maxDailyQuota,false);
            log.info(" map = " + map);

            List<Long> ids= bankService.getIdsByDynamicCondition(Bank.class, map, start, size);
            List<Bank> bankList = new ArrayList<>();
            Map<Long,Manager> managerHashMap = new HashMap<>();


            if(CollectionUtils.isEmpty(ids)){
                log.info(" get bank ids ,size is 0 " );

            }else {
                log.info(" get bank ids ,size is " + ids.size());
                bankList = bankService.getObjectsByIds(ids);
                List<Long> managerIds = new ArrayList<>();
                for(Bank bank : bankList){
                    managerIds.add(bank.getUpdateBy());
                }
                if(managerIds.size()>0){
                    List<Manager> managers = managerService.getObjectsByIds(managerIds);
                    for(Manager manager : managers){
                        managerHashMap.put(manager.getId(),manager);
                    }
                }

            }


            map =DynamicUtil.getBankList(bankName,createName,startAt,endAt,minSingleQuota,
                    maxSingleQuota,minDailyQuota,maxDailyQuota, true);
            BigInteger total = (BigInteger)bankService. getObjectByDynamicCondition(Bank.class,map,0,Integer.MAX_VALUE);
            log.info("get bank total is " + total);
            int totalPage = 1;
            if(null != total){
                if(total.intValue()>0){
                    totalPage = (((total.intValue() - 1)) / (size)) + 1;;
                }
            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);

            model.addAttribute("bankList", bankList);
            model.addAttribute("managerHashMap", managerHashMap);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get bank list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/bank/json/bankListJson";
    }


    /**
     * 查询单个
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/bank/{id}", method = RequestMethod.GET)
    public String getBankJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Bank bank = bankService.getObjectById(id);
            log.info("get bank data is " + bank);

            model.addAttribute("code", 0);

            model.addAttribute("bank", bank);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get bank error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/bank/json/bankDetailJson";
    }

    /**
     * 编辑
     * @param request
     * @param response
     * @param model
     * @param bank
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/bank/{id}", method = RequestMethod.POST)
    public String updateBankJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Bank bank,@PathVariable Long id ) throws Exception {

        Long mid = getUserId(request);

        log.info("manager : " + mid + " update bank : bank= " + bank);

        if(bank == null){
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        Manager manager = managerService.getObjectById(mid);
        if(null == manager){
            log.info("manager not exist");
            model.addAttribute("code", -1007);
            return "/common/success";
        }

        try {
            String code = "";
            Bank oldBank = bankService.getObjectById(id);
            if(null == oldBank){
                log.info("old bank not exist");
                model.addAttribute("code", -4009);
                return "/common/success";
            }else {
                code = bank.getBankCode();
                log.info("bank code : " + code);
            }

            if(StringUtil.isEmpty(bank.getBankName())){
                model.addAttribute("code", -1000);
                return "/data/json";
            }
            if(StringUtil.isEmpty(bank.getSingleQuota())){
                model.addAttribute("code", -1000);
                return "/data/json";
            }
            if(StringUtil.isEmpty(bank.getDailyQuota())){
                model.addAttribute("code", -1000);
                return "/data/json";
            }
            bank.setId(oldBank.getId());
            bank.setBankCode(code);
            bank.setCreateBy(oldBank.getCreateBy());
            bank.setUpdateBy(manager.getId());
            bank.setCreateAt(oldBank.getCreateAt());
            bankService.update(bank);

            model.addAttribute("code", 0);

            model.addAttribute("bank", bank);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update bank error,id is  " + bank.getId());
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }

    /**
     * 新增
     * @param request
     * @param response
     * @param model
     * @param bank
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/bank", method = RequestMethod.POST)
    public String addBankJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Bank bank) throws Exception {

        log.info("add bank : bank= " + bank);
        Long mid = getUserId(request);

        try {
            String code = "";
            if(bank == null){
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }else {
                code = bank.getBankCode();
                log.info("bank code : " + code);
            }

            Long bid = bankService.getBankIdByCode(code);
            if(bid != null){
                log.info("bank code already exist");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Manager manager = managerService.getObjectById(mid);
            if(null == manager){
                log.info("manager not exist");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            if(StringUtil.isEmpty(bank.getBankName())){
                model.addAttribute("code", -10000);
                return "/data/json";
            }
            if(StringUtil.isEmpty(bank.getSingleQuota())){
                model.addAttribute("code", -10002);
                return "/data/json";
            }
            if(StringUtil.isEmpty(bank.getDailyQuota())){
                model.addAttribute("code", -10003);
                return "/data/json";
            }

            bank.setId(null);
            bank.setCreateBy(manager.getId());
            bank.setUpdateBy(manager.getId());
            bankService.insert(bank);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add bank error ");
            model.addAttribute("code", -1);
        }

        return "/data/json";
    }

    /**
     * 删除
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/bank/{id}/del", method = RequestMethod.POST)
    public String deleteBankJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete bank : id= " + id);
        try {
            bankService.delete(id);

            log.info("add bank success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete bank error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }


    //银行卡限额
    @RequestMapping(value = "/a/u/bank/detail", method = RequestMethod.GET)
    public String getBankQuota(HttpServletRequest request, ModelMap model, String bankCode) throws Exception {

        Long mid = getUserId(request);
        log.info("manager " + mid + " get bank detail");

        if(DataUtils.isNullOrEmpty(bankCode)){
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            Long bid = bankService.getBankIdByCode(bankCode);
            Bank bank = bankService.getObjectById(bid);
            if(bank == null){
                log.info("bank not exist");
                model.addAttribute("code", -3039);
                return "/common/success";
            }else {
                log.info("bank : " + bank);
            }

            model.addAttribute("code", 0);
            model.addAttribute("bank", bank);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("manager " + mid + " get bank detail error");
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/bank/json/bankDetailJson";
    }
}

