package com.ptteng.wealth.admin.web;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

//import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.CookieUtil;

/**
 * Manager  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SsoManagerController {
    private static final Log log = LogFactory.getLog("sso");

    @Autowired
    private ManagerService managerService;
    @Autowired
    private CookieUtil cookieUtil;
    @Resource(name = "managerServiceConfig")
    private Map<String, String> managerServiceConfig;

    /**
     * 同步管理员数据
     */
    @RequestMapping(value = "/sso/manager")
    public String getOssManager(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @RequestBody String jsonObjectStr) throws Exception {
        try {

            Map<String, String> map = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String) headerNames.nextElement();
                String value = request.getHeader(key);
                map.put(key, value);
            }
            log.info("request map is : " + map + " |\n " + map.toString());

            jsonObjectStr = new String(jsonObjectStr.getBytes("iso-8859-1"),"UTF-8");

            JSONObject jsonData = new JSONObject(jsonObjectStr);
            log.info("==============================hello");
            log.info(jsonObjectStr);
//            JSONObject jsonData = jsonObjectStr;

            jsonData = jsonData.getJSONObject("json_data");

            String flag = jsonData.getString("flag");
            JSONObject content = jsonData.getJSONObject("content");
            String code = content.getString("UserCode");
            String status = content.getString("Status");
            log.info(" flag: " + flag + " UserCode: " + code + "  status: " + status);
            String statusStr = "";
            if ("1".equals(status) || "2".equals(status) || "3".equals(status)) {
                statusStr = Manager.STATUS_STOPPED;
            } else if ("0".equals(status)) {
                statusStr = Manager.STATUS_USING;
            } else {
                log.info(" wrong status");
                model.addAttribute("code", -1008);
                return "/common/success";
            }
//            }else if("2".equals(status)){
//                statusStr = Manager.STATUS_DELETED;
//            }
            Long mid = managerService.getManagerIdByCode(code);
            log.info(" UserCode: " + code + "  mid: " + mid);
            if (flag.equals("addUser")) {
                if (mid == null) {
                    Manager manager = new Manager();
                    manager.setCode(content.getString("UserCode"));
                    manager.setName(content.getString("LoginName"));
                    manager.setPwd(content.getString("EmployeeNumber"));
                    manager.setNick(content.getString("UserName"));
                    manager.setStatus(statusStr);
                    manager.setRoleID(172L);
                    log.info("manager: " + manager);
                    managerService.insert(manager);
                } else {
                    Manager manager = managerService.getObjectById(mid);
                    manager.setStatus(statusStr);
                    managerService.update(manager);
                }

            } else if (flag.equals("deleteUser")) {
                if (mid == null) {
                    log.info("no such manager");
                    model.addAttribute("code", -1007);
                    return "/common/success";
                }
                Manager manager = managerService.getObjectById(mid);
                manager.setStatus(statusStr);
                managerService.update(manager);
            } else if (flag.equals("updateUser")) {
                if (mid == null) {
                    log.info("no such manager");
                    model.addAttribute("code", -1007);
                    return "/common/success";
                }
                Manager manager = managerService.getObjectById(mid);
                manager.setName(content.getString("LoginName"));
                manager.setPwd(content.getString("EmployeeNumber"));
                manager.setNick(content.getString("UserName"));
                manager.setStatus(statusStr);
                manager.setRoleID(172L);
                managerService.update(manager);
            } else if (flag.equals("disableUser")) {
                if (mid == null) {
                    log.info("no such manager");
                    model.addAttribute("code", -1007);
                    return "/common/success";
                }
                Manager manager = managerService.getObjectById(mid);
                manager.setStatus(statusStr);
                managerService.update(manager);
            } else if (flag.equals("enableUser")) {
                if (mid == null) {
                    log.info("no such manager");
                    model.addAttribute("code", -1007);
                    return "/common/success";
                }
                Manager manager = managerService.getObjectById(mid);
                manager.setStatus(statusStr);
                managerService.update(manager);
            } else if (flag.equals("disConnect")) {
                if (mid == null) {
                    log.info("no such manager");
                    model.addAttribute("code", -1007);
                    return "/common/success";
                }
                Manager manager = managerService.getObjectById(mid);
                manager.setStatus(statusStr);
                managerService.update(manager);
            } else {
                log.info("flag wrong");
                model.addAttribute("code", -2015);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("get oss manager error");
        }
        log.info("=============================== success  end===================================================== \n");
        return "/common/success";
    }
}