package com.ptteng.wealth.admin.controller.product;

import com.ptteng.wealth.admin.model.ProductStatistics;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.admin.util.ProductStatisticsUtil.ProductDailyStatistics;
import com.ptteng.wealth.finance.model.Product;
import com.ptteng.wealth.finance.model.ProductDaily;
import com.ptteng.wealth.finance.service.ProductDailyService;
import com.ptteng.wealth.finance.service.ProductService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * ProductDaily  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProductDailyController {
	private static final Log log = LogFactory.getLog(ProductDailyController.class);



	@Autowired
	private ProductDailyService productDailyService;
	@Autowired
	private ProductService productService;

	public static String getDate(Long time){
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		String date = "";
		if(null != time){
			date = dateFormat.format(new Date(time));
		}
		return  date;
	}

	/**
	 * 按日的统计列表接口
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param productNo
	 * @param name
	 * @param startAt
	 * @param endAt
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/statistics/day/search", method = RequestMethod.GET)
	public String getproductList(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,Integer page,Integer size,
								 String productNo,String name,Long startAt,Long endAt,Long productId,
								 String period) throws Exception {
		log.info("page===" + page + "size====" + size+" productNo = "+productNo);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {


			if(StringUtils.isBlank(period)){
				period=DynamicUtil.Period_Day;
			}
			if(DynamicUtil.Period_Day.equals(period)){

			Map<String, Object> map = DynamicUtil.getProductDailyStatistcsList(productNo, name, startAt, endAt,productId,
					false);
			log.info(" get productDaily list param = "+map);
			List<Long> productDayilyIds =  productDailyService.getIdsByDynamicCondition(ProductDaily.class, map, start, size);
			log.info(" get productDaily list ids size = "+productDayilyIds.size());
			if(productDayilyIds.size()>0){
				List<ProductDaily> productDailyList = productDailyService.getObjectsByIds(productDayilyIds);
				List<Long> productIds = new ArrayList<>();
				for(ProductDaily productDaily : productDailyList){
					productIds.add(productDaily.getProductId());
				}
				log.info(" productIds size = "+productIds.size());
				List<Product> products = productService.getObjectsByIds(productIds);
				Map<Long,Product> productMap = new HashMap<>();
				for(Product product : products){
					productMap.put(product.getId(),product);
				}
				SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy-MM-dd");
				for(ProductDaily productDaily : productDailyList){
					productDaily.setName(productMap.get(productDaily.getProductId()).getName());
					productDaily.setStatus(productMap.get(productDaily.getProductId()).getStatus());
					productDaily.setDate(dateFormat.format(new Date(productDaily.getStaticAt())));
				}

				log.info(" productMap size = "+productMap.size());
				model.addAttribute("productMap",productMap);
				model.addAttribute("list",productDailyList);
			}
				BigInteger total = new BigInteger("0");
				BigInteger totalPage = new BigInteger("0") ;


				Map<String, Object> mapTotal = DynamicUtil.getProductDailyStatistcsList(productNo, name, startAt, endAt,productId,
						true);
				log.info(" get product total size param = "+mapTotal);
				total =(BigInteger)  productDailyService.getObjectByDynamicCondition(ProductDaily.class, mapTotal, 0, Integer.MAX_VALUE);
				log.info(" get product total size = "+total);
				totalPage = new BigInteger("1");
				if (total.compareTo(new BigInteger("0"))==1) {
					totalPage=((total.subtract(new BigInteger("1"))).divide(new BigInteger(""+size))).add(new BigInteger("1"));
				}
				model.addAttribute("total", total);
				model.addAttribute("totalPage", totalPage);
			}else {
				//周统计和月统计
				List<ProductDaily> productDailyList = new ArrayList<>();
				Map<String, Object> map = DynamicUtil.getStatisticsGroupParam(period,productNo, name, startAt, endAt);
				log.info(" get productDaily list param = " + map);
				Object results =  productDailyService.getObjectByDynamicCondition(ProductDaily.class, map, start, size);
				int i = 0;
				if(results instanceof ArrayList){
					ArrayList resultArrays=(ArrayList) results;
					int statisticsSize = resultArrays.size();
					for(Object result:resultArrays){
						Object[] rs=(Object[])result;

						ProductDaily productDaily = new ProductDaily();
						log.info(" 0 "+rs[0]+" 1="+rs[1]+" 2="+rs[2]+" week = "+rs[9]);
						productDaily.setProductId(Long.valueOf(rs[0] + ""));
						productDaily.setName((String) rs[1]);
						productDaily.setStatus((Integer) rs[2]);
						productDaily.setBuyCount(new BigDecimal(rs[3]+""));
						productDaily.setBuyPersonSum(new BigDecimal(rs[4]+""));
						productDaily.setBuySumAmount(new BigDecimal(rs[5]+""));
						productDaily.setWithdrawalAmount(new BigDecimal(rs[6]+""));
						productDaily.setWithdrawalCount(new BigDecimal(rs[7]+""));
						productDaily.setWithdrawalPersonSum(new BigDecimal(rs[8]+""));
						String week = rs[9]+"";
						productDaily.setDate(ProductDailyStatistics.getStatisticsDate(period,week,i,startAt,endAt,statisticsSize));


						productDailyList.add(productDaily);
						i++;
						log.info("week date is  "+productDaily.getDate());
					}


				}
				else{
					Object[] rs=(Object[])results;

					ProductDaily productDaily = new ProductDaily();
					log.info(" 0 "+rs[0]+" 1="+rs[1]+" 2="+rs[2]+" week = "+rs[9]);
					productDaily.setProductId(Long.valueOf(rs[0] + ""));
					productDaily.setName((String) rs[1]);
					productDaily.setStatus((Integer) rs[2]);
					productDaily.setBuyCount(new BigDecimal(rs[3]+""));
					productDaily.setBuyPersonSum(new BigDecimal(rs[4]+""));
					productDaily.setBuySumAmount(new BigDecimal(rs[5]+""));
					productDaily.setWithdrawalAmount(new BigDecimal(rs[6]+""));
					productDaily.setWithdrawalCount(new BigDecimal(rs[7]+""));
					productDaily.setWithdrawalPersonSum(new BigDecimal(rs[8]+""));
					String week = rs[9]+"";

					productDaily.setDate(ProductDailyStatistics.getStatisticsDate(period,week,i,startAt,endAt,1));
					productDailyList.add(productDaily);
					i++;
					log.info("week date is  "+productDaily.getDate());

				}

				model.addAttribute("list",productDailyList);



				Object totalResults =  productDailyService.getObjectByDynamicCondition(ProductDaily.class, map, 0, Integer.MAX_VALUE);
				if(totalResults instanceof ArrayList){
					ArrayList resultArrays=(ArrayList) totalResults;
					int total = ((ArrayList) totalResults).size();
					int totalPage = 1;
					if(total >0 ){
						totalPage = (total-1)/size+1;
					}
					model.addAttribute("total", total);
					model.addAttribute("totalPage", totalPage);
				}else{
					Object[] rs=(Object[])totalResults;
					log.info("  rs length = "+rs.length);
					int total = 0;
					if(rs.length==10){
						total = 1;
					}
					int totalPage = 1;
					model.addAttribute("total", total);
					model.addAttribute("totalPage", totalPage);
				}
			}
			model.addAttribute("code", 0);
			model.addAttribute("size", size);
			model.addAttribute("page", page);

		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get lotteryList  error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -1);
		}

		log.info("/web/product  to /product/json/productList");

		return "/wealth-finance-service/productDaily/json/productDailyListJson";
	}



	@RequestMapping(value = "/a/productDaily/{id}", method = RequestMethod.GET)
	public String getProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			ProductDaily productDaily = productDailyService.getObjectById(id);
			log.info("get productDaily data is " + productDaily);

			model.addAttribute("code", 0);

			model.addAttribute("productDaily", productDaily);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get productDaily error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/wealth-finance-service/productDaily/json/productDailyDetailJson";
	}

	@RequestMapping(value = "/a/productDaily/{id}", method = RequestMethod.PUT)
	public String updateProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, ProductDaily productDaily) throws Exception {
		
		log.info("update productDaily : productDaily= " + productDaily);
		
		try {
			
			productDailyService.update(productDaily);

			model.addAttribute("code", 0);

			model.addAttribute("productDaily", productDaily);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update productDaily error,id is  " + productDaily.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/productDaily", method = RequestMethod.POST)
	public String addProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, ProductDaily productDaily) throws Exception {
		
		log.info("update productDaily : productDaily= " + productDaily);
		
		try { 
			productDaily.setId(null);

			productDailyService.insert(productDaily);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add productDaily error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/productDaily/{id}", method = RequestMethod.DELETE)
	public String deleteProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete productDaily : id= " + id);
		try {
			productDailyService.delete(id);

			log.info("add productDaily success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete productDaily error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}




	/**
	 * 产品统计接口
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param productNo
	 * @param name
	 * @param startAt
	 * @param endAt
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/statistics/search", method = RequestMethod.GET)
	public String getProductStatisticsList(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,Integer page,Integer size,
								 String productNo,String name,Long startAt,Long endAt) throws Exception {
		log.info("page===" + page + "size====" + size+" productNo = "+productNo);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}


		log.info("pageList : page= " + start + " , size=" + size);

		try {
			List<ProductStatistics> list = DynamicUtil.getProductStatisticsListByMore(productNo, name, startAt, endAt,
					start,size);
			log.info(" get pro productStatistics list size  = "+list.size());

			model.addAttribute("list", list);

			List<ProductStatistics> listTotal = DynamicUtil.getProductStatisticsListByMore(productNo, name, startAt, endAt,
					0,Integer.MAX_VALUE);
			log.info(" get product total size = " + listTotal.size());
			int total = listTotal.size();
			int  totalPage =1;
			if (total>0) {
				totalPage=(total-1)/size +1;
			}

			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("size", size);
			model.addAttribute("page", page);

		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get lotteryList  error,page is  " + start + " , size "
					+ size);
			model.addAttribute("code", -1);
		}

		log.info("/web/product  to /product/json/productList");

		return "/wealth-finance-service/productDaily/json/productStatisticsListJson";
	}



}

