package com.ptteng.wealth.admin.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.admin.util.DebtConstant;
import com.ptteng.wealth.admin.util.sqlUtil;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.BalanceInquiryIn;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.out.BalanceInquiryOut;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.finance.model.DebtApply;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.OrgApply;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.service.OrgApplyService;
import com.ptteng.wealth.user.util.Constant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import org.springframework.web.bind.annotation.RequestParam;

import static java.lang.Math.ceil;

/**
 * 客户管理模块
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController extends BaseController {
    private static final Log log = LogFactory.getLog("user");

    @Autowired
    private UserService userService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private OrgApplyService orgApplyService;

    @Autowired
    private UserAccountRelationService userAccountRelationService;

    @RequestMapping(value = "/ab", method = RequestMethod.GET)
    public String ab(ModelMap model, HttpServletRequest request) throws Exception {
        String uri = (String)request.getAttribute("b");
        log.info("URI: " + uri);
        if (uri.equals("/a/hello")) {
            log.info("REDIRECT: "+request.getAttribute("u"));
            return "redirect:" + request.getAttribute("u");
        }
        model.addAttribute("code", -1009);
        log.info("REDIRECT: "+request.getAttribute("u"));
        model.addAttribute("jump" , request.getAttribute("u"));
//        return "sso";
        return "/common/logout";
    }


    /**
     * 客户管理
     */
    @RequestMapping(value = "/a/u/user/search", method = RequestMethod.GET)
    public String searchUser(ModelMap model, Integer status, Integer type, Integer risk, Long registerStartAt, Long registerEndAt,
                             String name, String mobile, @RequestParam(required = false) Integer page, Integer size) throws Exception {


        // 这里的name是单元name
        log.info("search user data : status: " + status + "  name: " + name + " mobile: " + mobile + " type: " + type);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {
//            Map<String, Object> param = DynamicUtil.getUserListParam(status, type, risk, registerStartAt, registerEndAt, name, mobile, false);
//            List<Long> ids = this.userService.getIdsByDynamicCondition(User.class, param, start, size + 1);
            List<User> users = DynamicUtil.getUserList(status, type, risk, registerStartAt, registerEndAt, name, mobile, start, size + 1);
            log.info("users size : " + users.size());
            List<User> totalIds = DynamicUtil.getUserList(status, type, risk, registerStartAt, registerEndAt, name, mobile, 0, Integer.MAX_VALUE);
            Integer totalSize = totalIds.size();
            List<User> list = new ArrayList();
            if (CollectionUtils.isEmpty(users)) {
                log.info("no ids");

            } else {
                Map<Long, String> uid_clientName = new HashMap<>();
                Map<Long, UserAccountRelation> accountAMap = new HashMap<>();
                Map<Long, UserAccountRelation> accountBMap = new HashMap<>();
                Map<Long, UserAccountRelation> accountCMap = new HashMap<>();

                list = users;
                Long aid = accountService.getObjectByCode(UserAccountRelation.Account_CODE_1);
                Account accountA = accountService.getObjectById(aid);
                Long bid = accountService.getObjectByCode(UserAccountRelation.Account_CODE_2);
                Account accountB = accountService.getObjectById(bid);
                Long cid = accountService.getObjectByCode(UserAccountRelation.Account_CODE_2);
                Account accountC = accountService.getObjectById(cid);

                model.addAttribute("accountA", accountA);
                model.addAttribute("accountB", accountB);
                model.addAttribute("accountC", accountC);

                for (User user : list) {
                    log.info("========== user : " + user.getId() + " ==========");
                    Long uarAId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(user.getId(), UserAccountRelation.Account_CODE_1);
                    UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(uarAId);
                    accountAMap.put(user.getId(), userAccountRelation);

                    Long uarBId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(user.getId(), UserAccountRelation.Account_CODE_2);
                    UserAccountRelation userAccountRelationB = userAccountRelationService.getObjectById(uarBId);
                    accountBMap.put(user.getId(), userAccountRelationB);

                    Long uarCId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(user.getId(), UserAccountRelation.Account_CODE_3);
                    UserAccountRelation userAccountRelationC = new UserAccountRelation();
                    if (null != uarCId) {
                        userAccountRelationC = userAccountRelationService.getObjectById(uarCId);
                    }
                    accountCMap.put(user.getId(), userAccountRelationC);

                    if(User.TYPE_PERSON.equals(user.getType())){
                        log.info("user type person");
                        Person person = personService.getObjectById(user.getId());
                        uid_clientName.put(user.getId(), person.getOrgName());
                    }else {
                        log.info("user type organization");
                        Organization organization = organizationService.getObjectById(user.getId());
                        if(null == organization){
                            log.info("organization not exist");
                            Long orgApplyId = orgApplyService.getOrgApplyIdByMobile(user.getMobile());
                            log.info("org apply id : " + orgApplyId);
                            OrgApply orgApply = orgApplyService.getObjectById(orgApplyId);
                            if(null != orgApply){
                                log.info("get user apply name : " + orgApply.getName());
                                uid_clientName.put(user.getId(), orgApply.getName());
                            }
                        }else {
                            log.info("organization exist");
                            uid_clientName.put(user.getId(), organization.getName());
                        }
                    }
                }
                model.addAttribute("accountAMap", accountAMap);
                model.addAttribute("accountBMap", accountBMap);
                model.addAttribute("accountCMap", accountCMap);
                model.addAttribute("uid_clientName", uid_clientName);

                if (list.size() == size + 1) {
                    log.info("has next page data ");
                    list = list.subList(0, size);
                } else {
                    log.info(" not get next page data ");
                }
                log.info("get list data size  is " + list.size());
                log.info("-----------------------------------");
                for (User user1 : list) {
                    log.info("user1 : " + user1.getName());
                }
                model.addAttribute("list", list);
            }
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("totalPage", totalPage(size, totalSize));
            model.addAttribute("total", totalSize);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-admin-web/user/json/userListJson";
    }


    /**
     * 获取用户详情
     *
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{uid}/detail", method = RequestMethod.GET)
    public String searchUser(ModelMap model, HttpServletResponse response, @PathVariable Long uid) throws Exception {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        // 这里的name是单元name
        log.info("get  user detail  data : " + uid);

        BigDecimal overTotalRepay = new BigDecimal("0");
        BigDecimal repayLine = new BigDecimal("0");
        BigDecimal overRepay = new BigDecimal("0");
        BigDecimal overRate = new BigDecimal("0");
        BigDecimal supposeRepay = new BigDecimal("0");
        BigDecimal totalRepay = new BigDecimal("0");
        BigDecimal debtCount = new BigDecimal("0");
        BigDecimal rate = new BigDecimal("0");
        BigDecimal dayCount = new BigDecimal("0");
        Long debtStart = 0L;
        Long time = 0L;

        try {

            log.info("1、用户个人机构信息===========================");
            User user = this.userService.getObjectById(uid);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/data/json";
            } else {
                log.info("user : " + user);
                if(user.getType().equals(User.TYPE_ORG)){
                    log.info("user : " + uid + " exist and type : org ");
                    Organization organization = organizationService.getObjectById(uid);
                    model.addAttribute("organization", organization);
                }else {
                    log.info("user : " + uid + " exist and type : person ");
                    Person person = personService.getObjectById(uid);
                    model.addAttribute("person", person);
                }
            }

            log.info("2、资金借贷信息===========================");
            Fund fund = fundService.getObjectById(uid);
            if(fund == null){
                Fund newFund = new Fund();
                newFund.setId(uid);
                Long fundId =  fundService.insert(newFund);
                log.info("  fundId = "+fundId);
            }else {
                log.info("get fund : " + uid + " success");
            }
            fund = fundService.getObjectById(uid);

            //还款中金额
            String repaySql = sqlUtil.getDynamicSql(null, null, uid, null, DebtApply.TYPE_REPAY, 0, Integer.MAX_VALUE);
            log.info("get repay apply sql is " + repaySql);
            List<DebtApply> repayApply = debtApplyService.getObjectsBySql(DebtApply.class, repaySql);
            log.info("get debt repay data is " + repayApply.size());

            for (DebtApply debtApply : repayApply) {
                //借款本金利率
                debtCount = debtApply.getDebtCount();
                rate = debtApply.getRate();

                //获取当前借款时间
                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
                time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

                //加上本息
                supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
                totalRepay = totalRepay.add(supposeRepay);
            }

            log.info(DebtApply.TYPE_OVERTIME);
            String debtSql = sqlUtil.getDynamicSql(null, null, uid, null, DebtApply.TYPE_OVERTIME, 0, Integer.MAX_VALUE);
            log.info("get overtime apply sql is " + debtSql);
            List<DebtApply> debtApplys = debtApplyService.getObjectsBySql(DebtApply.class, debtSql);
            log.info("get debt over time data is " + debtApplys.size());

            for (DebtApply debtApply : debtApplys) {
                log.info("debt apply id : " + debtApply.getId());

                //借款本金、利率
                debtCount = debtApply.getDebtCount();
                overRate = debtApply.getOverRate();
                rate = debtApply.getRate();

                //获取总借款利息
                repayLine = new BigDecimal(debtApply.getRepayLine());
                overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                //获取当前逾期时间
                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
                time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

                //获取当前罚息
                overRepay = caculate(overTotalRepay, overRate, dayCount).add(overTotalRepay);
                totalRepay = totalRepay.add(overRepay);
            }

            log.info("total repay : " + totalRepay);
            fund.setRepayTot(totalRepay);

            log.info("3、开磷账户信息===========================");
            List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
            List<Long> accountIds = accountService.getAccountIds(0, Integer.MAX_VALUE);
            List<Account> accounts = accountService.getObjectsByIds(accountIds);

            List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(user.getId(), 0, Integer.MAX_VALUE);
            relations = userAccountRelationService.getObjectsByIds(relationIds);

            Map<Long, String> code_name = new HashMap<>();
            if (accounts.size() != relations.size()) {
                for (Account account : accounts) {
                    int find = 0;
                    for (UserAccountRelation userAccountRelation : relations) {
                        if (account.getAccCode().equals(userAccountRelation.getAccountCode())) {
                            find = 1;
                        }
                    }
                    if (find == 0) {
                        UserAccountRelation userAccountRelation = new UserAccountRelation();
                        userAccountRelation.setAccountCode(account.getAccCode());
                        userAccountRelation.setAccountId(account.getId());
                        userAccountRelation.setAccountName(account.getName());
                        userAccountRelation.setUserId(uid);
                        userAccountRelation.setMoney(new BigDecimal("0"));
                        userAccountRelation.setCreateAt(System.currentTimeMillis());
                        userAccountRelation.setCreateBy(0l);
                        userAccountRelation.setUpdateAt(System.currentTimeMillis());
                        userAccountRelation.setUpdateBy(0l);
                        userAccountRelationService.insert(userAccountRelation);
                    }
                }
                relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(user.getId(), 0, Integer.MAX_VALUE);
                relations = userAccountRelationService.getObjectsByIds(relationIds);
            }

            for (Account account : accounts) {
                code_name.put(account.getId(), account.getName());
            }
            model.addAttribute("code_name", code_name);

            log.info("4、证联余额信息===========================");
            BalanceInquiryOut balance = new BalanceInquiryOut();
            balance.setTotalAmt(new BigDecimal("0"));
            balance.setTransAmt(new BigDecimal("0"));

            if (User.VERIFY_YES.equals(user.getVerifyStatus())) {
                try {
                    log.info("begin consign ");
                    BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
                    balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
                    balanceInquiryIn.setFundAccount(user.getFundAccount());
                    balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                    balanceInquiryIn.setUserId(user.getId() + "");
                    if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                        log.info("personal user");
                        Person person = personService.getObjectById(user.getId());
                        log.info("person : " + person);
                        balanceInquiryIn.setCertType("0");
                        balanceInquiryIn.setCertId(person.getIdNo());
                        balanceInquiryIn.setUserNameText(user.getName());
                    } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                        log.info("organization user");
                        Organization organization = organizationService.getObjectById(user.getId());
                        log.info("organization : " + organization);
                        balanceInquiryIn.setCertType(Constant.IDKIND);
                        balanceInquiryIn.setUserNameText(organization.getName());
                        balanceInquiryIn.setCertId(organization.getUseCertId());
                    }
                    balanceInquiryIn.setPassword(user.getPayPwd());
                    balanceInquiryIn.setGtTradePassword(user.getPayPwd());
                    balance = consignmentService.getBalance(balanceInquiryIn);
                    log.info(balance);
                    log.info(" 6 begin consign   " + balance);
                    if (null == balance.getTotalAmt()) {
                        log.info("no balance!");
                        balance.setTotalAmt(new BigDecimal("0"));
                        fund.setFund(new BigDecimal("0"));
                    }else {
                        fund.setFund(balance.getTotalAmt());
                    }
                } catch (Exception e) {
                    log.info(e.getMessage());
                }
            }

            log.info("4、证联银行卡信息===========================");
            List<BindingBank> resultBindingLs = new ArrayList<BindingBank>();
            try {
                BindingBankIn bindingBankIn = new BindingBankIn();
                bindingBankIn.setUserId(user.getId().toString());
                bindingBankIn.setFundAccount(user.getFundAccount());
                bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
                List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
                for (BindingBank bindingBank : bindingBanks) {
                    if (bindingBank.getBankNo().equals("JHB") || bindingBank.getBankNo().equals("XJY") || bindingBank.getBankNo().equals("ZLRT")) {
                        continue;
                    }
                    resultBindingLs.add(bindingBank);
                    log.info("Binding : " + bindingBank);
                }
            } catch (Throwable t) {
                t.printStackTrace();
                log.error(t.getMessage());
                log.error("get person " + uid + " card list error");
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("fund", fund);
            model.addAttribute("accounts", relations);
            model.addAttribute("bindingBanks", resultBindingLs);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get  user error " + uid);
            model.addAttribute("code", -1);
        }

        return "/wealth-admin-web/user/json/userDetailJson";
    }

    /**
     * 冻结/解冻 用户   status: 1--表示冻结用户    0 -- 表示解冻用户
     */
    @RequestMapping(value = "/a/u/user/{uid}/freeze/{status}")
    public String freezeUser(HttpServletResponse response, @PathVariable Long uid, @PathVariable Integer status) throws Exception {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        User user = userService.getObjectById(uid);
        user.setFreezeStatus(status);
        userService.update(user);
        objMap.put("code", 0);
        writeConent(response.getWriter(), response, true, 200, null, null, objMap, null);
        return null;
    }


    //计算利息
    public BigDecimal caculate(BigDecimal debtCount, BigDecimal rate, BigDecimal day) {
        log.info("caculate : debtCount = " + debtCount + " rate = " + rate + " day = " + day);
        if(null == rate){
            return BigDecimal.ZERO;
        }
        BigDecimal result = debtCount.multiply(day).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
        return result;
    }

}
   

    
