package com.ptteng.wealth.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.util.DebtConstant;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.admin.util.sqlUtil;
import com.ptteng.wealth.finance.model.*;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.DebtApplyService;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.finance.util.PayAccountUtil;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.service.UserService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

import static java.lang.Math.ceil;

/**
 * DebtApply crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DebtController extends BaseController {
    private static final Log log = LogFactory.getLog("debt");
    private static final Log depositPayLog = LogFactory.getLog("deposit_pay_log");
    @Autowired
    public UserAccountRelationService userAccountRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private DebtApplyService debtApplyService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private FundService fundService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private FundHistoryService fundHistoryService;

    /**
     * newCreditLine
     *
     * @param
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/debt/search", method = RequestMethod.GET)
    public String deptSearch(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
                             String mobile, String orderNo, Long startAt, Long endAt, Integer status, Integer page,
                             Integer size) throws Exception {// 这里的name是单元name
        log.info("search user data : ");

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Boolean next = false;
        try {

            Map<String, Object> param = DynamicUtil.getDebtListParam(name, mobile, orderNo, startAt, endAt, status, false);
            log.info("param is : " + param);
            List<Long> ids = this.debtApplyService.getIdsByDynamicCondition(DebtApply.class, param, start, size);

            Integer totalSize = debtApplyService.getIdsByDynamicCondition(DebtApply.class, param, 0, Integer.MAX_VALUE).size();
            model.addAttribute("total", totalSize);
            Integer totalPage = (((totalSize - 1)) / (size)) + 1;
            model.addAttribute("totalPage", totalPage);

            log.info("  totalPage = " + totalPage);
            List<DebtApply> list = new ArrayList();
            if (CollectionUtils.isEmpty(ids)) {
                log.info("no ids");

            } else {

                list = this.debtApplyService.getObjectsByIds(ids);
                if (list.size() == size + 1) {
                    log.info("has next page data ");
                    next = true;
                    list = list.subList(0, size);
                } else {
                    log.info(" not get next page data ");

                }
//                log.info(list);
                Set<Long> orderIDS = new HashSet();
                Set<Long> userIDS = new HashSet();
                Set<Long> fundIDS = new HashSet();
                Set<Long> managerIDS = new HashSet();
                Manager manager = new Manager();
                Manager secondManager = new Manager();
                Map<Long, String> id_manager = new HashMap<>();
                Map<Long, String> id_secondManager = new HashMap<>();

                // 1. 取order 2.取user 3.取fund
                for (DebtApply debtApply : list) {

                    orderIDS.add(debtApply.getOrderID());
                    userIDS.add(debtApply.getUid());
                    fundIDS.add(debtApply.getUid());

                    manager = managerService.getObjectById(debtApply.getVerifyBy());
                    secondManager = managerService.getObjectById(debtApply.getSecondVerifyBy());

                    if (null == manager) {
                        id_manager.put(debtApply.getId(), null);
                    } else {
                        id_manager.put(debtApply.getId(), manager.getNick());
                    }

                    if (null == secondManager) {
                        id_secondManager.put(debtApply.getId(), null);
                    } else {
                        id_manager.put(debtApply.getId(), secondManager.getNick());
                    }

                }
                List<Order> orders = this.orderService
                        .getObjectsByIds(new ArrayList(orderIDS));
                List<User> users = this.userService
                        .getObjectsByIds(new ArrayList(userIDS));
                List<Fund> funds = this.fundService
                        .getObjectsByIds(new ArrayList(userIDS));
                List<Manager> managers = this.managerService
                        .getObjectsByIds(new ArrayList(managerIDS));

                List<Organization> orgs = this.organizationService.getObjectsByIds(new ArrayList(userIDS));


                log.info("get list data is " + ids);
                model.addAttribute("list", list);
                Map<Long, Order> id_orders = MyListUtil.convert2Map(
                        Order.class.getDeclaredField("id"), orders);

                Map<Long, User> id_users = MyListUtil.convert2Map(
                        User.class.getDeclaredField("id"), users);

                Map<Long, Fund> id_funds = MyListUtil.convert2Map(
                        Fund.class.getDeclaredField("id"), funds);

                Map<Long, Organization> id_orgs = MyListUtil.convert2Map(
                        Organization.class.getDeclaredField("id"), orgs);

                log.info("id_orders " + id_orders);
                log.info("id_users " + id_users);
                log.info("id_manager" + id_manager);
                log.info("id_funds " + id_funds);
                log.info("id_orgs " + id_orgs);


                model.addAttribute("id_orders", id_orders);
                model.addAttribute("id_users", id_users);
                model.addAttribute("id_manager", id_manager);
                model.addAttribute("id_funds", id_funds);
                model.addAttribute("id_orgs", id_orgs);

            }

            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }

        return "/wealth-admin-web/debt/json/debtListJson";
    }


    @RequestMapping(value = "/a/u/debt/{id}", method = RequestMethod.GET)
    public String debtDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info("get debt detail : " + id);
        try {
            String verifyName = "";
            String secondVerifyName = "";

            DebtApply debtApply = debtApplyService.getObjectById(id);

            // 1. 取order 2.取user 3.取fund

            Order order = orderService.getObjectById(debtApply.getOrderID());
            log.info("order " + order);

            User user = userService.getObjectById(debtApply.getUid());
            log.info("user " + user);

            Fund fund = fundService.getObjectById(debtApply.getUid());
            log.info("fund " + fund);

            Organization org = organizationService.getObjectById(debtApply.getUid());
            log.info("org " + org);

            Manager verifyManager = managerService.getObjectById(debtApply.getVerifyBy());
            log.info("verifyManager id : " + debtApply.getVerifyBy());
            if (null != verifyManager) {
                verifyName = verifyManager.getNick();
            }

            Manager SecondVerifyManager = managerService.getObjectById(debtApply.getSecondVerifyBy());
            log.info("SecondVerifyManager id : " + debtApply.getSecondVerifyBy());
            if (null != SecondVerifyManager) {
                secondVerifyName = SecondVerifyManager.getNick();
            }

            model.addAttribute("verifyName", verifyName);
            model.addAttribute("secondVerifyName", secondVerifyName);
            model.addAttribute("debt", debtApply);
            model.addAttribute("order", order);
            model.addAttribute("user", user);
            model.addAttribute("fund", fund);
            model.addAttribute("org", org);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }

        return "/wealth-admin-web/debt/json/getDebtDetail";
    }


    /**
     * 借款审核
     * @param request
     * @param response
     * @param model
     * @param did
     * @param level
     * @param money
     * @param comment
     * @param repayLine
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/debt/{did}/verify/{level}", method = RequestMethod.POST)
    public String verifyDebt(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @PathVariable Long did, @PathVariable String level, String money,
                             String comment, Integer repayLine) throws Exception {// 这里的name是单元name
        log.info("verifyDebt did : " + did + " level id " + level + " money " + money + " comment " + comment);
        Long mid = getUserId(request);
        try {
            // 1 初审的话，必须有money
            if (StringUtils.isBlank(level)) {
                level = "1";
            }
            if ("1".equals(level)) {
                if (StringUtils.isBlank(money)) {
                    model.addAttribute("code", -11000);
                    return "/data/json";
                }
                if (repayLine == null) {
                    model.addAttribute("code", -11006);
                    return "/data/json";
                }
            }
            // 判断借贷在不在
            DebtApply debtApply = this.debtApplyService.getObjectById(did);
            if (debtApply == null) {
                model.addAttribute("code", -11003);
                return "/data/json";
            }

            if ("3".equals(level)) {
                // 驳回

                //
                if (DebtApply.STATUS_VERIFYING.equals(debtApply.getStatus())) {
                    debtApply.setStatus(DebtApply.STATUS_KAILIN_REFUSE);
                    debtApply.setVerifyBy(mid);

                }

                if (DebtApply.STATUS_KAILIN_PASS.equals(debtApply.getStatus())) {
                    debtApply.setStatus(DebtApply.STATUS_REFUSE);
                    debtApply.setSecondVerifyBy(mid);

                }
                debtApply.setReason(comment);
                this.debtApplyService.update(debtApply);
                Order order = this.orderService.getObjectById(debtApply.getOrderID());
                if (order == null) {
                    log.error(debtApply.getId() + " debt not get any order " + debtApply.getOrderID());

                } else {
                    order.setStatus(Order.STATUS_FAIL);
                    this.orderService.update(order);
                    log.info(debtApply.getId() + " update order status " + debtApply.getOrderID());

                }

            } else {
                // 判断审批金额是否在范围内
                BigDecimal m = new BigDecimal("0");

                try {
                    m = new BigDecimal(money);
                } catch (Throwable t) {
                    log.error(t);
                    t.printStackTrace();
                    log.error(money + " is wrong format ");

                    if ("1".equals(level)) {
                        model.addAttribute("code", -11004);
                        return "/data/json";
                    } else {
                        log.info("second not exam ");
                        m = debtApply.getDebtCount();
                    }
                }
                log.info("money is " + m);
                // 1.1 判断是否为负
                if (m.compareTo(new BigDecimal("0")) == -1) {
                    log.error(m + " is less than 0");
                    model.addAttribute("code", -11006);
                    return "/data/json";
                }
                // 1.2 判断是否超过定单范围
                Fund fund = this.fundService.getObjectById(debtApply.getUid());
                if (m.compareTo(fund.getCreditLine()) == 1) {
                    log.error(m + " is more than user credit  total  " + fund.getCreditLine());
                    model.addAttribute("code", -11002);
                    return "/data/json";
                }
                // 初审通过
                if ("1".equals(level)) {
                    if (!DebtApply.STATUS_VERIFYING.equals(debtApply.getStatus())) {
                        model.addAttribute("code", -11009);
                        return "/data/json";
                    }
                    // 第一次审核通过，只更改状态
                    debtApply.setStatus(DebtApply.STATUS_KAILIN_PASS);
                    debtApply.setRepayLine(repayLine);
                    debtApply.setVerifyAt(System.currentTimeMillis());
                    debtApply.setVerifyBy(mid);
                    debtApply.setDebtCount(m);
                    this.debtApplyService.update(debtApply);
                    log.info(debtApply + " first verify success ");
                }
                // 终审通过
                if ("2".equals(level)) {
                    log.info(" second verify ");
                    if (!DebtApply.STATUS_KAILIN_PASS.equals(debtApply.getStatus())) {
                        model.addAttribute("code", -11009);
                        return "/data/json";
                    }
                    // 第二次审核通过，更改状态，增加总贷款，累计的总贷款，应还总额
                    debtApply.setStatus(DebtApply.STATUS_PASS);
                    debtApply.setSecondVerifyAt(System.currentTimeMillis());
                    debtApply.setSecondVerifyBy(mid);
                    this.debtApplyService.update(debtApply);
                    log.info(debtApply + " second verify success ");
                }

            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -100000);
        }

        model.addAttribute("code", 0);
        return "/data/json";

    }


    //38、借款列表
    @RequestMapping(value = "/a/u/repay/list", method = RequestMethod.GET)
    public String getOverTimeRepay(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
                                   String mobile, String orderNo, Integer orderType, String repayStatus, Long createAtStart,
                                   Long createAtEnd, Long repayLineStart, Long repayLineEnd, Integer page, Integer size) throws Exception {

        log.info("search debt list by name : " + name + " mobile :" + mobile + " orderNo : " + orderNo + " orderType : " + orderType + " repayStatus : "
                + repayStatus + " createAtStart : " + createAtStart + " createAtEnd : " + createAtEnd + " repayLineStart : " + repayLineStart + " repayLineEnd : "
                + repayLineEnd + " page : " + page + " size : " + size);

        HashMap<Long, BigDecimal> id_totalRepay = new HashMap<>();
        HashMap<Long, BigDecimal> id_dayCount = new HashMap<>();
        HashMap<Long, BigDecimal> id_overRepay = new HashMap<>();
        HashMap<Long, String> uid_name = new HashMap<>();
        HashMap<Long, String> uid_mobile = new HashMap<>();
        BigDecimal dayCount = new BigDecimal("0");
        BigDecimal supposeRepay = new BigDecimal("0");
        BigDecimal overRepay = new BigDecimal("0");
        BigDecimal totalRepay = new BigDecimal("0");
        BigDecimal debtCount = new BigDecimal("0");
        BigDecimal overRate = new BigDecimal("0");
        BigDecimal repayLine = new BigDecimal("0");
        BigDecimal rate = new BigDecimal("0");
        HashMap<Long, BigDecimal> id_supposeRepay = new HashMap<>();
        List<DebtApply> debtApplys = new ArrayList<>();
        List<Long> uids = new ArrayList<>();
        Integer typeA = null;
        Integer typeB = null;
        Long debtStart = 0L;
        Long time = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        try {


            if ("1".equals(repayStatus)) {
                //未还款
                typeA = DebtApply.TYPE_CLEAR;
            } else if ("2".equals(repayStatus)) {
                //已还款
                typeA = DebtApply.TYPE_REPAY;
                typeB = DebtApply.TYPE_OVERTIME;
            } else {
                log.info("all repay status");
            }

            String overtimeSql = sqlUtil.getNotDynamicSql(name, orderNo, null, null, DebtApply.TYPE_VERIFYING, LoanApply.TYPE_CANCEL,
                    typeA, typeB, orderType, createAtStart, createAtEnd, repayLineStart, repayLineEnd, firstNmuber, size);
            log.info("get overtime apply sql is " + overtimeSql);
            debtApplys = debtApplyService.getObjectsBySql(DebtApply.class, overtimeSql);
            log.info("get debt overtime data is " + debtApplys.size());

            for (DebtApply debtApply : debtApplys) {
                //借款本金、利率
                debtCount = debtApply.getDebtCount();
                overRate = debtApply.getOverRate();
                rate = debtApply.getRate();

                if (DebtApply.TYPE_REPAY.equals(debtApply.getType())) {
                    log.info("repay debt : " + debtApply.getId());
                    //获取当前借款时间
                    debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getDebtAt()).getTime();
                    time = System.currentTimeMillis() - debtStart;
                    dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

                    //计算当前本息
                    supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
                    id_supposeRepay.put(debtApply.getId(), supposeRepay);
                } else if (DebtApply.TYPE_OVERTIME.equals(debtApply.getType())) {
                    log.info("over time debt : " + debtApply.getId());
                    //获取总借款利息
                    repayLine = new BigDecimal(debtApply.getRepayLine());
                    totalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
                    id_totalRepay.put(debtApply.getId(), totalRepay);

                    //获取当前逾期时间
                    debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
                    time = System.currentTimeMillis() - debtStart;
                    dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
                    id_dayCount.put(debtApply.getId(), dayCount);

                    //获取当前罚息
                    overRepay = caculate(totalRepay, overRate, dayCount);
                    id_overRepay.put(debtApply.getId(), overRepay.add(totalRepay));
                } else {
                    log.info("clear debt : " + debtApply.getId());
                }

                uids.add(debtApply.getUid());
            }

            List<User> users = userService.getObjectsByIds(uids);
            for (User user : users) {
                uid_name.put(user.getId(), user.getName());
                uid_mobile.put(user.getId(), user.getMobile());
            }

            log.info("   total = " + debtApplys.size());
            Integer totalPage = (((debtApplys.size() - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);
            if (debtApplys != null && debtApplys.size() > 0) {
                if (size.equals(debtApplys.size())) {
                    next = true;
                }
            }

            log.info("uid_name : " + uid_name);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("debtApplys", debtApplys);
            model.addAttribute("id_totalRepay", id_totalRepay);
            model.addAttribute("id_dayCount", id_dayCount);
            model.addAttribute("id_overRepay", id_overRepay);
            model.addAttribute("uid_name", uid_name);
            model.addAttribute("uid_mobile", uid_mobile);
            model.addAttribute("id_supposeRepay", id_supposeRepay);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get debt list error");
            model.addAttribute("code", -1);
        }
        return "/admin/debt/overTimeRepayDebtList";
    }


    //30、查看借款详情
    @RequestMapping(value = "/a/u/debt/detail/{id}", method = RequestMethod.GET)
    public String getDebtDetail(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {

        Long mid = getUserId(request);
        log.info("manager : " + mid + " get debt " + id + " detail");

        try {
            Manager manager = managerService.getObjectById(mid);
            if(null == manager){
                log.info("manager not exist");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            //第一步： 获取借款申请
            DebtApply debtApply = debtApplyService.getObjectById(id);
            log.info("2 ");
            //订单是否存在
            if (null == debtApply) {
                model.addAttribute("code", -3007);
                log.info("debt not exist");
                return "/common/success";
            }

            Long uid = debtApply.getUid();
            User user = userService.getObjectById(uid);
            if(user == null){
                log.info("debt user not exist");
                model.addAttribute("code", -4008);
                return "/common/success";
            }

            String repayName = "";
            Long updateId = debtApply.getUpdateBy();
            Manager repayManager = managerService.getObjectById(updateId);
            if(repayManager == null){
                log.info("no manager repay");
            }else {
                repayName = repayManager.getNick();
                log.info("repay manager : " + repayName);
            }

            //第二步： 获取借款申请所对应的订单信息
            Order order = orderService.getObjectById(debtApply.getOrderID());
            log.info("orderId: " + order);
            log.info("3 ");

            //第四步： 获取开磷账户信息
            String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
            //非常关键，获取要支付的开磷账号
            Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
            UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
            Account account = accountService.getObjectById(userAccountRelation.getAccountId());
            userAccountRelation.setAccountName(account.getName());
            model.addAttribute("userAccount", userAccountRelation);
            log.info("use account relation : " + userAccountRelation);

            //第六步：根据借款申请类型获得详情参数
            Integer type = debtApply.getType();
            if (DebtApply.TYPE_OVERTIME == type) {
                BigDecimal debtCount = debtApply.getDebtCount();
                BigDecimal overRate = debtApply.getOverRate();
                BigDecimal rate = debtApply.getRate();

                //获取总借款利息
                BigDecimal repayLine = new BigDecimal(debtApply.getRepayLine());
                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                //获取当前逾期时间
                Long debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
                Long time = System.currentTimeMillis() - debtStart;
                BigDecimal dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

                //获取当前罚息
                BigDecimal overRepay = caculate(overTotalRepay, overRate, dayCount);
                BigDecimal totalMoney = overTotalRepay.add(overRepay);

                debtApply.setOverDayCount(dayCount);
                debtApply.setClearOverInte(overRepay);
                debtApply.setRepayTot(totalMoney);
            } else if (DebtApply.TYPE_REPAY.equals(debtApply.getType())) {
                log.info("repay debtApply ");

                //借款本金、利率
                BigDecimal debtCount = debtApply.getDebtCount();
                BigDecimal overRate = debtApply.getOverRate();
                BigDecimal rate = debtApply.getRate();

                //获取总借款利息
                BigDecimal repayLine = new BigDecimal(debtApply.getRepayLine());
                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
                debtApply.setRepayTot(overTotalRepay);

            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("repayName", repayName);
            model.addAttribute("debtApply", debtApply);
            model.addAttribute("order", order);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get debt detail error , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/getLoanDetail";
    }


    //32、借贷还款总额
    @RequestMapping(value = "/a/u/debt/pay/amount/{id}", method = RequestMethod.GET)
    public String getDebtRepayAmount(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {

        BigDecimal payCount = new BigDecimal("0");
        Integer result = 0;
        Long mid = getUserId(request);
        depositPayLog.info("====================================================================");
        depositPayLog.info(" PAY Deposit mid : " + mid + "  LoanApplyId: " + id);
        try {

            Manager manager = managerService.getObjectById(mid);
            if(null == manager){
                log.info("manager not exist");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            DebtApply debtApply = debtApplyService.getObjectById(id);
            if(null == debtApply){
                log.info("debt apply not exist");
                model.addAttribute("code", -11003);
                return "/common/success";
            }else {
                log.info("debt info : " + debtApply);
            }

            depositPayLog.info("DebtApply status : " + debtApply.getStatus());
            if (!DebtApply.STATUS_REPAY.equals(debtApply.getStatus()) && !DebtApply.STATUS_OVERTIME.equals(debtApply.getStatus())) {
                model.addAttribute("code", -3029);
                depositPayLog.info("PARAMFAIL: the debt not pass");
                return "/common/success";
            }
            Long oid = debtApply.getOrderID();
            Order order = orderService.getObjectById(oid);
            if (null == order) {
                model.addAttribute("code", -3015);
                depositPayLog.info("PARAMFAIL: no such order");
                return "/common/success";
            }

            //生成需要更新的数据，利息，罚息，逾期天数，还款总额，还款时间
            //借款本金、利率
            BigDecimal dayCount = new BigDecimal("0");
            BigDecimal overRepay = new BigDecimal("0");
            BigDecimal totalRepay = new BigDecimal("0");
            BigDecimal debtCount = new BigDecimal("0");
            BigDecimal overRate = new BigDecimal("0");
            BigDecimal repayLine = new BigDecimal("0");
            BigDecimal rate = new BigDecimal("0");
            BigDecimal lx = new BigDecimal("0");
            BigDecimal totalMoney = new BigDecimal("0");


            debtCount = debtApply.getDebtCount();
            overRate = debtApply.getOverRate();
            rate = debtApply.getRate();

            //获取总借款利息
            repayLine = new BigDecimal(debtApply.getRepayLine());
            lx = caculate(debtCount, rate, repayLine);
            totalRepay = lx.add(debtCount);

            //获取当前逾期时间
            long debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getDebtAt()).getTime();
            long time = System.currentTimeMillis() - debtStart;
            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
            if (dayCount.doubleValue() < 0) {
                dayCount = new BigDecimal("0");
            }

            //获取当前罚息
            overRepay = caculate(totalRepay, overRate, dayCount);

            //待还总额
            totalMoney = totalRepay.add(overRepay);

            model.addAttribute("code", result);
            model.addAttribute("data", totalMoney);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            depositPayLog.error(t.getMessage());
            depositPayLog.error("update updateDebt deposi , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/data";
    }


    //32、借贷还款
    @RequestMapping(value = "/a/u/debt/pay/{id}", method = RequestMethod.PUT)
    public String repay(HttpServletRequest request, ModelMap model, @PathVariable Long id, String pwd) throws Exception {

        BigDecimal payCount = new BigDecimal("0");
        Integer result = 0;
        Long mid = getUserId(request);
        depositPayLog.info("====================================================================");
        depositPayLog.info(" PAY Deposit mid : " + mid + "  LoanApplyId: " + id + "  pwd: " + pwd);
        try {

            Manager manager = managerService.getObjectById(mid);
            if(null == manager){
                log.info("manager not exist");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            DebtApply debtApply = debtApplyService.getObjectById(id);
            if(null == debtApply){
                log.info("debt apply not exist");
                model.addAttribute("code", -11003);
                return "/common/success";
            }else {
                log.info("debt info : " + debtApply);
            }

            depositPayLog.info("DebtApply status : " + debtApply.getStatus());
            if (!DebtApply.STATUS_REPAY.equals(debtApply.getStatus()) && !DebtApply.STATUS_OVERTIME.equals(debtApply.getStatus())) {
                model.addAttribute("code", -3029);
                depositPayLog.info("PARAMFAIL: the debt not pass");
                return "/common/success";
            }
            Long oid = debtApply.getOrderID();
            Order order = orderService.getObjectById(oid);
            if (null == order) {
                model.addAttribute("code", -3015);
                depositPayLog.info("PARAMFAIL: no such order");
                return "/common/success";
            }

            //管理员密码
            String passwords = manager.getPwd();
            depositPayLog.info(" pwd : " + pwd + " manager passwords: " + passwords);
            boolean verify = passwords.equals(pwd);
            // TODO 此处的密码验证是错的，不应该验证FSP本系统的密码，因为SSO没有下发密码，正确的做法是通过接口去验证SSO中的密码
            verify = true;
            depositPayLog.info(" verify: " + verify);
            if (!verify) {
                depositPayLog.info("manager : " + mid + " wrong password " + pwd);
                model.addAttribute("code", -2004);
                return "/common/success";
            }

            //生成需要更新的数据，利息，罚息，逾期天数，还款总额，还款时间
            //借款本金、利率
            BigDecimal dayCount = new BigDecimal("0");
            BigDecimal overRepay = new BigDecimal("0");
            BigDecimal totalRepay = new BigDecimal("0");
            BigDecimal debtCount = new BigDecimal("0");
            BigDecimal overRate = new BigDecimal("0");
            BigDecimal repayLine = new BigDecimal("0");
            BigDecimal rate = new BigDecimal("0");
            BigDecimal lx = new BigDecimal("0");
            BigDecimal totalMoney = new BigDecimal("0");


            debtCount = debtApply.getDebtCount();
            overRate = debtApply.getOverRate();
            rate = debtApply.getRate();

            //获取总借款利息
            repayLine = new BigDecimal(debtApply.getRepayLine());
            lx = caculate(debtCount, rate, repayLine);
            totalRepay = lx.add(debtCount);

            //获取当前逾期时间
            long debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getDebtAt()).getTime();
            long time = System.currentTimeMillis() - debtStart;
            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
            if (dayCount.doubleValue() < 0) {
                dayCount = new BigDecimal("0");
            }

            //获取当前罚息
            overRepay = caculate(totalRepay, overRate, dayCount);

            //待还总额
            totalMoney = totalRepay.add(overRepay);

            //第二步：通过开磷账户进行支付

            depositPayLog.info(" KAILIN  PAY .. ");
            String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
            //非常关键，获取要支付的开磷账号
            Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(debtApply.getUid(), accountCode);
            depositPayLog.info(" accountCode: " + accountCode + "  userAccountId: " + userAccountId + " payCount: " + payCount.doubleValue() + " debtCount: " + debtApply.getDebtCount().doubleValue() + " orderId: " + order + " loanApply: " + debtApply.getId());
            if (null != userAccountId) {

                //修改借款申请
                debtApply = updateDebtApply(debtApply, overRepay, lx, totalMoney, dayCount, mid);
                debtApplyService.update(debtApply);
                depositPayLog.info(" update debtApply success");

                UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
                BigDecimal money = userAccountRelation.getMoney();
                userAccountRelation.setMoney(money.subtract(totalMoney));
                userAccountRelationService.update(userAccountRelation);
                depositPayLog.info("money : " + money + " >>>>>>>>>> " + userAccountRelation.getMoney());

                User user = userService.getObjectById(debtApply.getUid());

                Long transactionId = fundHistoryService.insertTransaction(order, user, FundHistory.TYPE_Pay, FundHistory.DETAIL_Repay, userAccountId,
                        totalMoney, null, FundHistory.FLAG_Out, FundHistory.STATUS_Pass, null, money, userAccountRelation.getMoney());
                log.info("insert transaction success : id " + transactionId);

            } else {
                result = -3022;
            }
            depositPayLog.info("DB result: " + result);
            model.addAttribute("code", result);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            depositPayLog.error(t.getMessage());
            depositPayLog.error("update updateDebt deposi , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //计算利息
    public BigDecimal caculate(BigDecimal debtCount, BigDecimal rate, BigDecimal day) {
        log.info("caculate : debtCount = " + debtCount + " rate = " + rate + " day = " + day);
        if (null == rate) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = debtCount.multiply(day).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
        return result;
    }

    //清还借款，保存信息
    public DebtApply updateDebtApply(DebtApply debtApply, BigDecimal overRepay, BigDecimal lx, BigDecimal totalMoney,
                                     BigDecimal dayCount, Long mid) throws Exception {
        depositPayLog.info("update DebtApply : debtApply = " + debtApply + " overRepay = " + overRepay + " lx = " + lx + " totalMoney = " + totalMoney + " dayCount = " + dayCount);

        debtApply.setType(DebtApply.TYPE_CLEAR);
        debtApply.setStatus(DebtApply.STATUS_CLEAR);
        debtApply.setClearOverInte(overRepay);
        debtApply.setClearInte(lx);
        debtApply.setRepayTot(totalMoney);
        debtApply.setOverDayCount(dayCount);
        debtApply.setClearAt(System.currentTimeMillis());
        debtApply.setUpdateAt(System.currentTimeMillis());
        debtApply.setUpdateBy(mid);

        Fund fund = fundService.getObjectById(debtApply.getUid());
        BigDecimal loanNowTot = fund.getLoanNowTot();
        fund.setLoanNowTot(fund.getLoanNowTot().subtract(debtApply.getDebtCount()));
        fundService.update(fund);
        depositPayLog.info("loanNowTot : " + loanNowTot + " >>>>>>>>>> " + fund.getLoanNowTot());

        return debtApply;
    }

}
