package com.ptteng.uweiqian.home.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name =  "article")
public class Article implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8751915544773635072L;

	/**
	 * article类型
	 * type=1：购彩技巧；

	 type=2：banner管理；

	 type=3：精彩活动管理；

	 type=4：push管理；

	 type=5：频道广告管理；

	 type=6：帮助中心管理；

	 type=7：启动页管理；
	 type=8：版本管理；

	 */
	public static final Integer TYPE_1=1;
	public static final Integer TYPE_2=2;
	public static final Integer TYPE_3=3;
	public static final Integer TYPE_4=4;
	public static final Integer TYPE_5=5;
	public static final Integer TYPE_6=6;
	public static final Integer TYPE_7=7;
	public static final Integer TYPE_8=8;


	/**
	 * 活动条件
	 * 1--注册、2--签到、3--实名、4--绑卡、5--充值、6–购彩、7--摇奖
	 */
	public static final Integer SITUATION_1=1;
	public static final Integer SITUATION_2=2;
	public static final Integer SITUATION_3=3;
	public static final Integer SITUATION_4=4;
	public static final Integer SITUATION_5=5;
	public static final Integer SITUATION_6=6;
	public static final Integer SITUATION_7=7;

	/**
	 * push管理的人群：
	 * 1--所有用户
	 */
	public static final Integer PUSH_1=1;

	/**
	 * 精彩活动，活动奖品
	 * type:彩金：1/体验金：2 /红包：3
	 */
	public static final Integer ACTIVITY_1=1;
	public static final Integer ACTIVITY_2=2;
	public static final Integer ACTIVITY_3=3;

	//已推送
	public static final Integer status_normal = 1;
	//未推送
	public static final Integer status_freeze = 2;

	/**
	 *  未发布
	 * 
	 */
	public static final Integer Status_Unpublished = 1;

	/**
	 * 发布
	 */
	public static final Integer Status_Published = 2;//强制更新

	/**
	 *  已删除
	 * 
	 */
	public static final Long Status_Deleted = 0L;
    	
   	 
    private Long id;
	
  	 
    private Integer type;
	
  	 
    private String img;
	
  	 
    private String title;
	
  	 
    private Integer orderBy;
	
  	 
    private String author;
	
  	 
    private String source;
	
  	 
    private String content;
	
  	 
    private String summary;
	
  	 
    private Long createBy;
	
  	 
    private Long updateBy;
	
  	 
    private Long publishat;
	
  	 
    private Long updateAt;
	
  	 
    private Long createAt;
	
  	 
    private Integer status;

	private Integer pushStatus;


    /**
     * url地址
     */
    private String url;

	/**
	 * 推送人群
	 */
	private Integer personType;
	/**
	 * 活动条件
	 */
	private Integer situation;
	/**
	 * 活动开始日期
	 */
	private Long startAt;
	/**
	 * 活动结束日期
	 */
	private Long endAt;
	/**
	 * 活动奖品
	 */
	private String prize;
	/**
	 * 彩种ID
	 */
	private String lotteryType;
	/**
	 * 推送时间
	 */
	private Long pushAt;

	private String situationReadable;

	private String createByName;
	private Integer jumpType;
	private String version;


	@Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
	@Column(name = "version")
	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	@Column(name = "jump_type")
	public Integer getJumpType() {
		return jumpType;
	}

	public void setJumpType(Integer jumpType) {
		this.jumpType = jumpType;
	}

	@Transient
	public String getCreateByName() {
		return createByName;
	}

	public void setCreateByName(String createByName) {
		this.createByName = createByName;
	}

	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "img")
	public String getImg() {
		return img;
	}
	
	
	public void setImg(String img) {
		this.img = img;
	}
		 	@Column(name = "title")
	public String getTitle() {
		return title;
	}
	
	
	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name = "situation_readable")
	public String getSituationReadable() {
		return situationReadable;
	}

	public void setSituationReadable(String situationReadable) {
		this.situationReadable = situationReadable;
	}

	@Column(name = "author")
	public String getAuthor() {
		return author;
	}
	
		 	
		 	
	@Column(name = "orderBy")
	public Integer getOrderBy() {
		return orderBy;
	}


	public void setOrderBy(Integer orderBy) {
		this.orderBy = orderBy;
	}


	public void setAuthor(String author) {
		this.author = author;
	}
		 	@Column(name = "source")
	public String getSource() {
		return source;
	}
	
	
	public void setSource(String source) {
		this.source = source;
	}
		 	@Column(name = "content")
	public String getContent() {
		return content;
	}
	
	
	public void setContent(String content) {
		this.content = content;
	}
		 	@Column(name = "summary")
	public String getSummary() {
		return summary;
	}
	
	
	public void setSummary(String summary) {
		this.summary = summary;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "publish_at")
	public Long getPublishat() {
		return publishat;
	}
	
	
	public void setPublishat(Long publishat) {
		this.publishat = publishat;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
	
	
	
		


 	@Column(name = "url")
	public String getUrl() {
		return url;
	}


	public void setUrl(String url) {
		this.url = url;
	}

	@Column(name = "person_type")
	public Integer getPersonType() {
		return personType;
	}

	public void setPersonType(Integer personType) {
		this.personType = personType;
	}
	@Column(name = "situation")
	public Integer getSituation() {
		return situation;
	}

	public void setSituation(Integer situation) {
		this.situation = situation;
	}
	@Column(name = "start_at")
	public Long getStartAt() {
		return startAt;
	}

	public void setStartAt(Long startAt) {
		this.startAt = startAt;
	}
	@Column(name = "end_at")
	public Long getEndAt() {
		return endAt;
	}

	public void setEndAt(Long endAt) {
		this.endAt = endAt;
	}
		@Column(name = "prize")
	public String getPrize() {
		return prize;
	}

	public void setPrize(String prize) {
		this.prize = prize;
	}
	@Column(name = "lottery_type")
	public String getLotteryType() {
		return lotteryType;
	}

	public void setLotteryType(String lotteryType) {
		this.lotteryType = lotteryType;
	}






	@Column(name = "push_at")
	public Long getPushAt() {
		return pushAt;
	}

	public void setPushAt(Long pushAt) {
		this.pushAt = pushAt;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
	@Column(name ="push_status")
	public Integer getPushStatus() {
		return pushStatus;
	}

	public void setPushStatus(Integer pushStatus) {
		this.pushStatus = pushStatus;
	}
}

