package com.ptteng.util;


import com.gemantic.common.util.StringUtil;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.uweiqian.organization.model.User;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;

import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {
    public static String convertTable(Set<String> tables) {
        StringBuffer tableBuffer = new StringBuffer();
        int index = 0;
        Iterator var4 = tables.iterator();

        while(var4.hasNext()) {
            String table = (String)var4.next();
            ++index;
            tableBuffer = tableBuffer.append(table);
            if(index < tables.size()) {
                tableBuffer = tableBuffer.append(",");
            }
        }

        return tableBuffer.toString();
    }
	public static Map<String,Object>getUserApplyListParam(String uid,String status,String startTime,String endTime,String name,Boolean count){
		Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("user_apply");
		// 商户ID
		if (StringUtil.isNotEmpty(uid)) {
			params.put("user_id", uid);
		}
		// 审核状态
		if (StringUtil.isNotEmpty(status)) {
			params.put("status", status);
		}
		// 注册时间
		if (StringUtil.isNotEmpty(startTime)&& DataUtils.isNotNullOrEmpty(endTime)) {
			params.put(" update_at& BETWEEN ", "'" + startTime + "' AND '" + endTime + "'");
		}
		//商户名称
		if (StringUtil.isNotEmpty(name))
		{
            params.put(" user.name & like ","'%"+name+"%'");
            params.put("user_apply.user_id", "user.id");
            tables.add("user");
		}
		String table = convertTable(tables);
		params.put("@table", table);
		if (count) {
			params.put("@query", " count(user_apply.id) ");
		} else {
			params.put("@query", " user_apply.id ");
			params.put("@order", " user_apply.create_at desc ");
		}
		return params;
	}
    public static Map<String, Object> getArticleListParam(Long startAt, Long endAt,
                                                          String type, String createBy, String source, String status,
                                                          String title,String content,Integer situation,Boolean activity,
                                                          Boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" update_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" update_at & <= ", "'" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", "'" + createBy + "'");
        }
        if (DataUtils.isNotNullOrEmpty(source)) {
            params.put("source", " '" + source + "' ");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);

        }
        if(StringUtil.isNotEmpty(title)){
            params.put("title",title);
        }
        if(StringUtil.isNotEmpty(content)){
            params.put("content",content);
        }
        if (DataUtils.isNotNullOrEmpty(situation)) {
            params.put("situation",situation);
        }
        Long now = System.currentTimeMillis();
        if(activity){
            params.put(" start_at & <= ",now );
            params.put(" end_at & >= ",now );

        }


        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  article ");

        return params;
    }

    //
    public static Map<String, Object> getLessonList(String name, Long subjectId, Integer level) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", "'" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("level", "'" + level + "'");
        }
        params.put("@order", "  level desc ");
        params.put("@query", " id");

        params.put("@table", " lesson ");

        return params;
    }

    public static Map<String, Object> getPeriodList(Integer level, String name, Long lessonId,
                                                    Long subjectId, Integer type) {
        Map<String, Object> params = new HashedMap();
        System.out.println(name + "name" + "lessonId" + lessonId + "subjectID" + subjectId + "type" + type);
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(lessonId)) {

            params.put("lesson_id", "'" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectId)) {

            params.put("subject_id", "'" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put("type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(level)) {

            params.put("level", "'" + level + "'");
        }


        params.put("@order", "  create_at desc ");
        params.put("@query", " id ");

        params.put("@table", "  period ");

        return params;

    }
//	public static Map<String, Object> getUpStreamList(String name,Integer keep) {
//		Map<String, Object> params = new HashedMap();
//		if (DataUtils.isNotNullOrEmpty(name)) {
//			params.put("name & like", " '%" + name + "%'");
//		}
////		if (keep == 1) {
////			params.put("keep", keep);
////		}
//			params.put("type", 1);
//			params.put("@order", "  create_at desc ");
//			params.put("@query", "id");
//		params.put("@table", " stream ");
//
//		return params;
//
//	}


//    public static Map<String, Object> getArticleListParam(Long startAt, Long endAt,
//                                                          String type, String createBy, String source, String status,
//                                                          String title, String content, Integer situation, String lotteryType,
//                                                          Boolean count) {
//
//        Map<String, Object> params = new HashMap<String, Object>();
//        Set<String> tables = new HashSet();
//        tables.add("article");
//
//        if (DataUtils.isNotNullOrEmpty(startAt)) {
//            params.put(" article.create_at & >= ", "'" + startAt + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(endAt)) {
//            params.put(" article.create_at & <= ", "'" + endAt + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(type)) {
//            params.put("article.type", "'" + type + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(createBy)) {
//            params.put("article.create_by", "'" + createBy + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(source)) {
//            params.put("article.source", " '" + source + "' ");
//        }
//        if (DataUtils.isNotNullOrEmpty(status)) {
//            params.put("article.status", "'" + status + "'");
//
//        }
//        if (StringUtil.isNotEmpty(title)) {
//            params.put("article.title & like ", "'%" + title + "%'");
//        }
//        if (StringUtil.isNotEmpty(content)) {
//            params.put("article.content & like ", "'%" + content + "%'");
//        }
//        if (DataUtils.isNotNullOrEmpty(situation)) {
//            params.put("article.situation", "'" + situation + "'");
//        }
//        if (StringUtil.isNotEmpty(lotteryType)) {
//            params.put("article.lottery_type ", "'" + lotteryType + "'");
//        }
//        if (StringUtil.isNotEmpty(createBy)) {
//            params.put(" manager.name & like ", "'%" + createBy + "%'");
//            params.put("article.create_by", "manager.id");
//
//            tables.add("manager");
//        }
//
//        if (count) {
//            params.put("@query", " count(id) ");
//        } else {
//            params.put("@order", "  article.orderBy asc ");
//            params.put("@query", " article.id ");
//        }
//        String table = RedUtil.convertTable(tables);
//        params.put("@table", table);
//
//        return params;
//    }


    public static Map<String, Object> getSingleFieldParam(String queryField,
                                                          String table) {
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("@order", queryField);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getStatisticsListParam(Long upstreamID,
                                                             Long downstreamID, Long productID, Long startAt, Long endAt, Integer statisticsType,
                                                             boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("statistics");

        if (upstreamID != null) {
            params.put("upstream_id", upstreamID);

        }

        if (downstreamID != null) {

            params.put("downstream_id", downstreamID);


        }

        if (productID != null) {
            params.put("product_id", productID);

        }

        if (statisticsType != null) {
            params.put("statistics_type", statisticsType);

        }


        if (startAt != null) {

            params.put("time & >= ", startAt);

        }
        if (endAt != null) {
            params.put("time & <= ", endAt);

        }


        if (count) {
            params.put("@query", " count(statistics.id) ");
        } else {


            params.put("@order", "  statistics.time desc ");

            params.put("@query", " statistics.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getStatisticsGroupParam(Long upstreamID,
                                                              Long downstreamID, Long productID, Long startAt, Long endAt,
                                                              Integer statisticsType) {
        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer queryParam = new StringBuffer();
        StringBuffer groupParam = new StringBuffer();
        Set<String> tables = new HashSet();
        tables.add("statistics");
        queryParam = queryParam.append("sum(statistics_count)");
        queryParam = queryParam.append(",");
        queryParam = queryParam.append("DATE_FORMAT( FROM_UNIXTIME ( time/ 1000),'%Y%u' ) as week");

        groupParam = groupParam.append("week");

        if (upstreamID != null) {
            params.put("upstream_id", upstreamID);
            queryParam = queryParam.append(",");
            queryParam = queryParam.append("upstream_id");
            groupParam = groupParam.append(",");
            groupParam = groupParam.append("upstream_id");


        }

        if (downstreamID != null) {

            params.put("downstream_id", downstreamID);
            queryParam = queryParam.append(",");
            queryParam = queryParam.append("downstream_id");
            groupParam = groupParam.append(",");
            groupParam = groupParam.append("downstream_id");


        }

        if (productID != null) {
            params.put("product_id", productID);
            queryParam = queryParam.append(",");
            queryParam = queryParam.append("product_id");
            groupParam = groupParam.append(",");
            groupParam = groupParam.append("product_id");

        }

        if (statisticsType != null) {
            params.put("statistics_type", statisticsType);

        }


        if (startAt != null) {

            params.put("time & >= ", startAt);

        }
        if (endAt != null) {
            params.put("time & <= ", endAt);

        }


        params.put("@query", queryParam.toString());
        params.put("@group", groupParam.toString());
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getBookList(String name, Integer grade, Integer term) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("statistics");
        if (name != null) {
            params.put("name", name);
        }
        if (grade != null) {
            params.put("grade", grade);
        }
        if (term != null) {
            params.put("term", term);
        }


        params.put("@order", " sort");

        params.put("@query", " id ");


        params.put("@table", " book");

        return params;

    }


    public static Map<String, Object> getMessageList(String name, Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer type) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", " '%" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(messageType)) {
            params.put("messageType", "'" + messageType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(timeLow)) {
            params.put("create_at&>", "'" + timeLow + "'");
        }
        if (DataUtils.isNotNullOrEmpty(timeHigh)) {
            params.put("create_at&<", "'" + timeHigh + "'");
        }
        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " message ");

        return params;
    }


    public static Map<String, Object> getTaskList(Long subjectId, Long lessonId, Long periodId) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subjectId", " '" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(lessonId)) {
            params.put("lessonId", " '" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put("periodId", " '" + periodId + "'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " paper ");

        return params;
    }

    public static Map<String, Object> getPaperList(Long subjectId, Long lessonId, Long periodId) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subjectId", " '" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(lessonId)) {
            params.put("lessonId", " '" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put("periodId", " '" + periodId + "'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " paper ");

        return params;
    }


    public static Map<String, Object> getSubjectList(Integer type, String name) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", " '" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " subject ");

        return params;
    }

    public static Map<String, Object> getCollaborateList(String name) {
        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " collaborate ");

        return params;
    }


    public static Map<String, Object> getTaskList(Integer type, String name, Long subjectId, Long lessonId, Long periodId) {
        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(subjectId)) {
            params.put("subject_id", " '" + subjectId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", " '" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(lessonId)) {
            params.put("lesson_id", " '" + lessonId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(periodId)) {
            params.put("period_id", " '" + periodId + "'");
        }
        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " task ");

        return params;
    }

//    //  天天摇奖的动态查询
//    public static Map<String, Object> getPrizeList(Long creatAtStart, Long creatAtEnd, String prizeName, Integer status, Long createBy,
//                                                   Integer page, Integer size,String createByName, Boolean count) {
//        Map<String, Object> params = new HashedMap();
//        Set<String>  tables = new HashSet();
//        tables.add("prize");
//
//        if (DataUtils.isNotNullOrEmpty(creatAtStart)) {
//            params.put(" prize.create_at & >= ", "'" + creatAtStart + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(creatAtEnd)) {
//            params.put(" prize.create_at & <= ", "'" + creatAtEnd + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(status)) {
//            params.put("prize.status","'"+ status+"'");
//        }
//        if (DataUtils.isNotNullOrEmpty(createBy)) {
//            params.put("prize.create_by","'"+ createBy+"'");
//        }
//        if (DataUtils.isNotNullOrEmpty(prizeName)) {
//            params.put("prize.prize_name & like ","'%"+ prizeName+"%'");
//        }
//        if(DataUtils.isNotNullOrEmpty(createByName)){
//            params.put(" manager.name & like ","'%"+createByName+"%'");
//            params.put("prize.create_by","manager.id");
//        tables.add("manager");
//        }
//
//        if (count) {
//            params.put("@query", " count(id) ");
//        } else {
//            params.put("@order", "  prize.create_at asc ");
//            params.put("@query", " prize.id ");
//        }
//        String table=RedUtil.convertTable(tables);
//        params.put("@table", table);
//
//        return params;
//
//    }

//    //渠道管理查询的动态查询
//    public static Map<String, Object> getChannelList(Long creatAtStart, Long creatAtEnd, String channelNo,
//                                                     String channelName, String createByName,
//                                                     Long platform, Integer page, Integer size, Boolean count) {
//        Map<String, Object> params = new HashedMap();
//        Set<String> tables = new HashSet();
//        tables.add("channel");
//
//        if (DataUtils.isNotNullOrEmpty(creatAtStart)) {
//            params.put(" channel.create_at & >= ","'" + creatAtStart + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(creatAtEnd)) {
//            params.put(" channel.create_at & <= ","'" + creatAtEnd + "'");
//        }
//        if (DataUtils.isNotNullOrEmpty(channelNo)) {
//            params.put("channel.channel_no", "'"+channelNo+"'");
//        }
//        if (DataUtils.isNotNullOrEmpty(createByName)) {
//
//            params.put(" manager.name & like ", "'%" + createByName + "%'");
//            params.put("channel.create_by", "manager.id");
//
//            tables.add("manager");
//        }
//        if (DataUtils.isNotNullOrEmpty(channelName)) {
//            params.put("channel.channel_name & like", " '%" + channelName + "%'");
//        }
//        if (DataUtils.isNotNullOrEmpty(platform)) {
//            params.put("channel.platform", "'"+platform+"'");
//        }
//
//
//
//        if (count) {
//            params.put("@query", " count(id) ");
//        } else {
//            params.put("@order", "  channel.create_at asc ");
//            params.put("@query", " channel.id ");
//        }
//        String table =RedUtil.convertTable(tables);
//        params.put("@table", table);
//
//        return params;
//
//    }

    public static Map<String, Object> getBankCardList(Long startAt, Long endAt, String mobile, String name, String bank, String cardNo, Boolean count) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" create_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" create_at & <= ", "'" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put("phone & like ", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(bank)) {
            params.put("bank ", "'" + bank + "'");
        }
        if (DataUtils.isNotNullOrEmpty(cardNo)) {
            params.put("card_no & like ", "'%" + cardNo + "%'");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  create_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", "  bankcard ");

        return params;
    }

}