package com.ptteng.common.uweiqian.controller;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import com.qding.common.util.FileUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.util.BeanToMap;
import com.ptteng.util.DynamicUtil;
import com.ptteng.uweiqian.organization.model.User;
import com.ptteng.uweiqian.organization.model.UserApply;
import com.ptteng.uweiqian.organization.service.UserApplyService;
import com.ptteng.uweiqian.organization.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;

/**
 * Role crud
 *
 * @author magenm 2014-4-16 13:43
 *
 */
@Controller
public class UserApplyController {
	private static final Log log = LogFactory.getLog(UserController.class);
	@Autowired
	private UserApplyService userApplyService;
	@Autowired
	private UserService userService;

	@Autowired
	private ImgStorageUtil imgStorageUtil;

	/***
	 * 
	 * 用户提交资料记录列表 /a/u/user/apply/search 根据用户id查询用户提交资料列表
	 */
	@RequestMapping(value = "/a/u/user/apply/search", method = RequestMethod.GET)
	public String getUserApplyJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size, String name, String mname, String status, String startTime, String endTime,
			String uid) throws Exception {
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}

		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			List<Long> ids = null;
			Boolean next = false;
			// size += 1;
			Map<String, Object> map = new HashMap<String, Object>();
			Map<String, Object> mapTotal = DynamicUtil.getUserApplyListParam(uid,status, startTime, endTime, name, true);
			log.info(" get userApply total size param = " + mapTotal);
			BigInteger total = (BigInteger) userApplyService.getObjectByDynamicCondition(UserApply.class, mapTotal, 0,
					Integer.MAX_VALUE);
			log.info(" get userApply total size = " + total);
			map = DynamicUtil.getUserApplyListParam(uid,status, startTime, endTime, name, false);
			ids = userApplyService.getIdsByDynamicCondition(UserApply.class, map, start, size);
			List<UserApply> submitRecordList = userApplyService.getObjectsByIds(ids);
			log.info("get getUserApplyJsonList size is " + ids.size());
			List<HashMap<String, Object>> subRecordMap = new ArrayList<HashMap<String, Object>>();
			//商户
			List<Long> userIds = new ArrayList<Long>();
			for (UserApply userApply : submitRecordList) {
				if (null != userApply.getUserId()) {
					userIds.add(userApply.getUserId());
				}
			}
			List<User> userList = new ArrayList<User>();
			userList = userService.getObjectsByIds(userIds);
			for (UserApply userApply : submitRecordList) {
				HashMap<String, Object> hashmap = new HashMap<String, Object>();
				BeanToMap beanTomap = new BeanToMap();
				hashmap = beanTomap.beanToMap(userApply);
				if (userList.size() > 0) {
					for (User user : userList) {
						if (user.getId().equals(userApply.getUserId())) {
							// 用户名
							hashmap.put("name", user.getName());
							// 手机号
							hashmap.put("mobile", user.getMobile());
						}
					}
				}
				subRecordMap.add(hashmap);
			}
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			if (submitRecordList.size() % size == 0) {
				model.addAttribute("totalPage", submitRecordList.size() / size);
			} else {

				model.addAttribute("totalPage", submitRecordList.size() / size + 1);
			}
			model.addAttribute("subRecordMap", subRecordMap);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get UserApply list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-uweiqian-service/submitrecord/json/submitRecordList";
	}

	@RequestMapping(value = "/a/u/user/apply/{uid}", method = RequestMethod.POST)
	public String insertSubmitRecord(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long uid, UserApply userApply) throws Exception {
		try {
			userApply.setStatus(1);
			userApply.setUserId(uid);
			userApplyService.insert(userApply);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("insert UserApply error");
			// for test
			model.addAttribute("code", -100000);
		}
		return "/common/success";
	}

	// 38 .图片上传
	@RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
	public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@RequestParam MultipartFile file, @PathVariable String module) throws Exception {
		log.info("hello upload " + module);
		if (StringUtils.isBlank(module)) {
			log.info("type is null");
		}
		int code = 0;
		log.info(file.getOriginalFilename());

		// User user = (User) request.getAttribute("user");
		// Long uid = user.getId();
		try {

			String extend = FileUtil.getFileExtension(file.getOriginalFilename());

			String fileName = UUID.randomUUID().toString() + "." + extend;
			log.info("new name is " + fileName);
			// String filePath = "/temp/" + fileName;
			String filePath = "/data/img/uweiqian/" + module + "/" + fileName;
			String dirPath = "/data/img/uweiqian/" + module;

			File dir = new File("/data/img/uweiqian/" + module);
			if (dir.exists()) {
				log.info("创建目录" + dirPath + "失败，目标目录已经存在");
			} else {
				// 创建目录
				if (dir.mkdirs()) {
					log.info("创建目录" + dirPath + "成功！");
				} else {
					log.info("创建目录" + dirPath + "失败！");
				}
			}

			File tempPic = new File(filePath);
			file.transferTo(tempPic);
			String url = this.imgStorageUtil.imgStorage(null, "uweiqian/" + module + "/" + fileName, filePath);
			log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
					+ " access url is " + url);
			// tempPic.delete();
			// log.info(file.getOriginalFilename() + " delete success ");
			model.addAttribute("url", url);
			model.addAttribute("code", 0);

			return "/common/img";
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/common/success";
	}
}
