package com.ptteng.sca.uweiqian.home.client.Pay;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.uweiqian.home.service.Pay.IndentInfoService;

import org.osoa.sca.annotations.Reference;

/**
 * Created by liangxj on 2016/3/10.
 */
public class IndentInfoSCAClient implements IndentInfoService {

    private IndentInfoService indentInfoService;

    public IndentInfoService getIndentInfoService() {
        return indentInfoService;
    }

    @Reference
    public void setIndentInfoService(IndentInfoService indentInfoService) {
        this.indentInfoService = indentInfoService;
    }

    @Override
    public String getIndentByIndentCode(String indentCode) throws ServiceException, ServiceDaoException {

        return indentInfoService.getIndentByIndentCode(indentCode);
    }

    @Override
    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
        indentInfoService.noticeBack(indentCode, respCode, payManner);
    }

    @Override
    public void paymentStatus(Long fundId,Long userId, Double income, int respCode) throws ServiceException, ServiceDaoException {
        indentInfoService.paymentStatus(fundId,userId,income,respCode);
    }


    @Override
    public Boolean AliPayStatusQuery(String orderId)throws ServiceException, ServiceDaoException
    {
        return indentInfoService.AliPayStatusQuery(orderId);
    }

    @Override
    public Boolean setPayAt(String orderId,Long payAt)throws ServiceException, ServiceDaoException {
        return indentInfoService.setPayAt(orderId,payAt);
    }
}
