/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Record;
import com.ptteng.common.skill.service.RecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordServiceImpl
extends BaseDaoServiceImpl
implements RecordService {
    private static final Log log = LogFactory.getLog(RecordServiceImpl.class);

    public Long insert(Record record) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + record));
        if (record == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        record.setCreateAt(Long.valueOf(currentTimeMillis));
        record.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)record);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + record));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Record> insertList(List<Record> recordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (recordList == null ? "null" : Integer.valueOf(recordList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(recordList)) {
            return new ArrayList<Record>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Record record : recordList) {
            record.setCreateAt(Long.valueOf(currentTimeMillis));
            record.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(recordList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + recordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Record.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Record record) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (record == null ? "null" : record.getId())));
        boolean result = false;
        if (record == null) {
            return true;
        }
        record.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)record);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + record));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + record));
        }
        return result;
    }

    public boolean updateList(List<Record> recordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (recordList == null ? "null" : Integer.valueOf(recordList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(recordList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Record record : recordList) {
            record.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(recordList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + recordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + recordList.size()));
        return result;
    }

    public Record getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Record record = null;
        if (id == null) {
            return record;
        }
        try {
            record = (Record)this.dao.get(Record.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return record;
    }

    public List<Record> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List record = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Record>();
        }
        try {
            record = this.dao.getList(Record.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (record == null ? "null" : Integer.valueOf(record.size()))));
        return record;
    }

    public Long getRecordIdByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid  : " + uid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getRecordIdByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getRecordIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRecordIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRecordIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRecordIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRecordIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

