/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.service.AccountService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccountServiceImpl
extends BaseDaoServiceImpl
implements AccountService {
    private static final Log log = LogFactory.getLog(AccountServiceImpl.class);

    public Long insert(Account account) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + account));
        if (account == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        account.setCreateAt(Long.valueOf(currentTimeMillis));
        account.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)account);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + account));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Account> insertList(List<Account> accountList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (accountList == null ? "null" : Integer.valueOf(accountList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(accountList)) {
            return new ArrayList<Account>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Account account : accountList) {
            account.setCreateAt(Long.valueOf(currentTimeMillis));
            account.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(accountList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + accountList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Account.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Account account) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (account == null ? "null" : account.getId())));
        boolean result = false;
        if (account == null) {
            return true;
        }
        account.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)account);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + account));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + account));
        }
        return result;
    }

    public boolean updateList(List<Account> accountList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (accountList == null ? "null" : Integer.valueOf(accountList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(accountList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Account account : accountList) {
            account.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(accountList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + accountList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + accountList.size()));
        return result;
    }

    public Account getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Account account = null;
        if (id == null) {
            return account;
        }
        try {
            account = (Account)this.dao.get(Account.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return account;
    }

    public List<Account> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List account = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Account>();
        }
        try {
            account = this.dao.getList(Account.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (account == null ? "null" : Integer.valueOf(account.size()))));
        return account;
    }

    public List<Long> getAccountIdsByAccount(String account, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by account,start,limit  : " + account + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountIdsByAccount", new Object[]{account}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by account,start,limit)  : " + account + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getAccountByMobile(String mobile, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by account,start,limit  : " + mobile + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountByMobile", new Object[]{mobile}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by account,start,limit)  : " + mobile + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getAccountIdsByServerIdandStatus(Long serverId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by serverId , status,start,limit  : " + serverId + "," + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountIdsByServerIdandStatus", new Object[]{serverId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by ,start,limit)  : " + serverId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getAccountIdsByServerId(Long serverId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by account,start,limit  : " + serverId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountIdsByServerId", new Object[]{serverId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by account,start,limit)  : " + serverId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getAccountByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        List idList = null;
        log.info((Object)"impl ==== get");
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by account,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return idList;
    }

    public List<Long> getAccountByStatus(Integer status, Integer start, Integer limit) throws ServiceDaoException, ServiceDaoException {
        List idList = null;
        log.info((Object)"impl ==== get");
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        log.info((Object)("the parame is " + status + start + limit));
        try {
            idList = this.dao.getIdList("getAccountByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by account,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return idList;
    }

    public List<Long> getAccountByStatusAndType(Integer status, Long type, Integer start, Integer limit) throws ServiceDaoException, ServiceDaoException {
        List idList = null;
        log.info((Object)"impl ==== g===");
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        log.info((Object)("the parame is " + status + type + start + limit));
        try {
            idList = this.dao.getIdList("getAccountByStatusAndType", new Object[]{status, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by account,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return idList;
    }

    public Integer countAccountIdsByAccount(String account) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by account  : " + account));
        }
        Integer count = null;
        try {
            count = this.dao.count("getAccountIdsByAccount", new Object[]{account});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by account)  : " + account));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getAccountIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAccountIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getAccountIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getAccountIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Integer countAccountByUid(Long uid) throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("countAccountByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (count == null ? "null" : Long.valueOf(count.longValue()))));
        }
        return count;
    }

    public List<Long> getExpireAccountIds(Long endTime, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by endTime,start,limit  : " + endTime + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getExpireAccountIds", new Object[]{endTime}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by endTime,start,limit)  : " + endTime + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

