package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.UserScore;
import com.ptteng.common.skill.service.UserScoreService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserScoreServiceImpl extends BaseDaoServiceImpl implements UserScoreService {



	private static final Log log = LogFactory.getLog(UserScoreServiceImpl.class);




	@Override
	public Long insert(UserScore userScore)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + userScore);

		if (userScore == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userScore.setCreateAt(currentTimeMillis);
		userScore.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userScore);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userScore);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<UserScore> insertList(List<UserScore> userScoreList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (userScoreList == null ? "null" : userScoreList.size()));

		List<UserScore> resultList = null;

		if (CollectionUtils.isEmpty(userScoreList)) {
			return new ArrayList<UserScore>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserScore userScore : userScoreList) {
			userScore.setCreateAt(currentTimeMillis);
			userScore.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserScore>) dao.batchSave(userScoreList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userScoreList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserScore.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(UserScore userScore)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (userScore == null ? "null" : userScore.getId()));

		boolean result = false;

		if (userScore == null) {
			return true;
		}

		userScore.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userScore);
		} catch (DaoException e) {
			log.error(" update wrong : " + userScore);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + userScore);
		}
		return result;
	}


	@Override
	public boolean updateList(List<UserScore> userScoreList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (userScoreList == null ? "null" : userScoreList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userScoreList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserScore userScore : userScoreList) {
			userScore.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userScoreList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userScoreList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + userScoreList.size());

		return result;
	}


	@Override
	public UserScore getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		UserScore userScore = null;

		if (id == null) {
			return userScore;
		}

		try {
			userScore = (UserScore) dao.get(UserScore.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return userScore;
	}


	@Override
	public List<UserScore> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<UserScore> userScore = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserScore>();
		}

		try {
			userScore = (List<UserScore>) dao.getList(UserScore.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (userScore == null ? "null" : userScore.size()));

		return userScore;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserScoreIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserScoreIdsByUid", new Object[] { uid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserScoreIdsByUid(Long uid)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by uid  : " + uid );
		}
		Integer count=null;



		try {

			count = dao.count("getUserScoreIdsByUid", new Object[] { uid});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getUserScoreIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserScoreIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countUserScoreIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserScoreIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserScoreIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

