package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.QuestionLabelRelation;
import com.ptteng.common.skill.service.QuestionLabelRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class QuestionLabelRelationServiceImpl extends BaseDaoServiceImpl implements QuestionLabelRelationService {

 

	private static final Log log = LogFactory.getLog(QuestionLabelRelationServiceImpl.class);



		   
		@Override
		public Long insert(QuestionLabelRelation questionLabelRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + questionLabelRelation);

		if (questionLabelRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		questionLabelRelation.setCreateAt(currentTimeMillis);
		questionLabelRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(questionLabelRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + questionLabelRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<QuestionLabelRelation> insertList(List<QuestionLabelRelation> questionLabelRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (questionLabelRelationList == null ? "null" : questionLabelRelationList.size()));
      
		List<QuestionLabelRelation> resultList = null;

		if (CollectionUtils.isEmpty(questionLabelRelationList)) {
			return new ArrayList<QuestionLabelRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
			questionLabelRelation.setCreateAt(currentTimeMillis);
			questionLabelRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<QuestionLabelRelation>) dao.batchSave(questionLabelRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + questionLabelRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(QuestionLabelRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(QuestionLabelRelation questionLabelRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (questionLabelRelation == null ? "null" : questionLabelRelation.getId()));

		boolean result = false;

		if (questionLabelRelation == null) {
			return true;
		}

		questionLabelRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(questionLabelRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + questionLabelRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + questionLabelRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<QuestionLabelRelation> questionLabelRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (questionLabelRelationList == null ? "null" : questionLabelRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(questionLabelRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
			questionLabelRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(questionLabelRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + questionLabelRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + questionLabelRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public QuestionLabelRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		QuestionLabelRelation questionLabelRelation = null;

		if (id == null) {
			return questionLabelRelation;
		}

		try {
			questionLabelRelation = (QuestionLabelRelation) dao.get(QuestionLabelRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return questionLabelRelation;		
		}	
		  
    	   
		@Override
		public List<QuestionLabelRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<QuestionLabelRelation> questionLabelRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<QuestionLabelRelation>();
		}

		try {
			questionLabelRelation = (List<QuestionLabelRelation>) dao.getList(QuestionLabelRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (questionLabelRelation == null ? "null" : questionLabelRelation.size()));
    
		return questionLabelRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getQuestionLabelRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getQuestionLabelRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countQuestionLabelRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getQuestionLabelRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getQuestionLabelRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

