/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.ptteng.common.skill.model.Cities;
import com.ptteng.common.skill.model.Counties;
import com.ptteng.common.skill.model.InDoorStudentStatistics;
import com.ptteng.common.skill.model.Provinces;
import com.ptteng.common.skill.model.Record;
import com.ptteng.common.skill.service.TemplateTestService;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TemplateTestServiceImpl
implements TemplateTestService {
    private static final Log log = LogFactory.getLog(TemplateTestServiceImpl.class);
    private JdbcTemplate template;
    private static final Integer CONDITION_AGE = 1;
    private static final Integer CONDITION_CITY = 2;
    private static final Integer CONDITION_GRADE = 3;
    private static final Integer CONDITION_MAJOR = 4;
    private static final Integer CONDITION_SCHOOL = 5;

    public JdbcTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    public void updateIsLookNumber() {
        String sql = "update user a set a.is_look = (select count(id) from message b where b.receive_id = a.id and b.unread = 1 and b.type!=\"collection\" and b.type!=\"like\" and b.type!=\"private\") where a.is_look < 0;";
        log.info((Object)("update users isLook by execute sql: " + sql));
        this.template.update(sql);
    }

    public List<InDoorStudentStatistics> getLineChartByParams(String school, String place, String major, Integer grade, Integer occupationId, Integer age, Long minStartAt, Long maxStartAt) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> objectList = new ArrayList<Object>();
        String prefix = "select b.day as day, b.number as number, (@totalNumber := @totalNumber + b.number) as totalNumber from (select (c.DAY_SHORT_DESC-86400000) as day, IFNULL(a.number,0) as number from calendar c LEFT JOIN (select UNIX_TIMESTAMP(DATE_FORMAT(FROM_UNIXTIME(u.start_at/1000), '%Y-%m-%d'))*1000 AS day, IFNULL(count(u.id),0) AS number from user u";
        String suffix = " and u.identity >=40 and u.identity < 60 GROUP BY day) a on a.day = (c.DAY_SHORT_DESC - 86400000) where (c.DAY_SHORT_DESC-86400000) < (UNIX_TIMESTAMP(NOW())*1000) and c.DAY_SHORT_DESC > 0)b JOIN (select @totalNumber := 0) s;";
        if (StringUtils.isNotEmpty((CharSequence)school) || StringUtils.isNotEmpty((CharSequence)place) || StringUtils.isNotEmpty((CharSequence)major) || DataUtils.isNotNullOrEmpty((Object)grade)) {
            sb.append(prefix + ", record r where r.uid = u.id ");
            if (StringUtils.isNotEmpty((CharSequence)school)) {
                sb.append(" and r.school like CONCAT('%',?,'%')");
                objectList.add(school);
            }
            if (StringUtils.isNotEmpty((CharSequence)place)) {
                sb.append(" and CONCAT(r.province,r.city,r.county) like CONCAT('%',?,'%')");
                objectList.add(place);
            }
            if (StringUtils.isNotEmpty((CharSequence)major)) {
                sb.append(" and r.major like CONCAT('%',?,'%')");
                objectList.add(major);
            }
            if (DataUtils.isNotNullOrEmpty((Object)grade)) {
                sb.append(" and r.grade = ?");
                objectList.add(grade);
            }
        } else {
            sb.append(prefix + " where 1 = 1");
        }
        if (DataUtils.isNotNullOrEmpty((Object)occupationId)) {
            sb.append(" and u.oid = ?");
            objectList.add(occupationId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)age)) {
            if (age.equals(0)) {
                sb.append("");
            }
            if (age.equals(1)) {
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) < 18");
            }
            if (age.equals(2)) {
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) >= 18 and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) <= 24");
            }
            if (age.equals(3)) {
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) >= 25 and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) < 30");
            }
            if (age.equals(4)) {
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) > 30");
            }
        }
        if (DataUtils.isNotNullOrEmpty((Object)minStartAt)) {
            sb.append(" and u.start_at >= ?");
            objectList.add(minStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)maxStartAt)) {
            sb.append(" and u.start_at <= ?");
            objectList.add(maxStartAt);
        }
        sb.append(suffix);
        log.info((Object)("query by sql: [" + sb.toString() + "]"));
        log.info((Object)("execute query sql by params: " + objectList));
        return this.template.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(InDoorStudentStatistics.class), objectList.toArray());
    }

    public List<InDoorStudentStatistics> getPieCharByParams(Long minPassAt, Long maxPassAt, Long minStartAt, Long maxStartAt, Long minGraduateAt, Long maxGraduateAt, Integer occupationId, Integer condition) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Number> objectList = new ArrayList<Number>();
        String prefix = "";
        String suffix = "";
        if (ObjectUtils.equals((Object)condition, (Object)CONDITION_AGE)) {
            prefix = "select a.item item, count(a.item) number FROM (select case when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) <18 then '18\u5c81\u4ee5\u4e0b' when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) >= 18 and TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) <= 24 then '18~24\u5c81' when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) >= 25 and TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) < 30 then '25~30\u5c81' when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) >= 30 then '30\u5c81\u4ee5\u4e0a' end as item from record r";
            suffix = "r.status = 3) a group by a.item ORDER BY number desc limit 0, 10;";
        } else if (ObjectUtils.equals((Object)condition, (Object)CONDITION_CITY)) {
            prefix = "select case d.city when -1 then '\u672a\u77e5' when -1-1 then '\u672a\u77e5' else d.city end as item, count(d.city) number from (select SUBSTRING_INDEX(c.city,'\u7701',-1) city from (select SUBSTRING_INDEX(b.city,'\u81ea\u6cbb\u533a',-1) city from (select SUBSTRING_INDEX(CONCAT(a.city),'\u5e02\u8f96\u533a',1) city from (select SUBSTRING_INDEX(CONCAT(r.province, r.city),'\u53bf',1) city from record r";
            suffix = "r.status = 3) a) b) c) d group by city order by number desc limit 0, 10;";
        } else if (ObjectUtils.equals((Object)condition, (Object)CONDITION_GRADE)) {
            prefix = "select case r.grade when -1 then '\u672a\u77e5' when 1 then '\u5c0f\u5b66' when 2 then '\u521d\u4e2d' when 3 then '\u9ad8\u4e2d' when 4 then '\u4e13\u79d1' when 5 then '\u4e2d\u4e13' when 6 then '\u5927\u4e13' when 7 then '\u672c\u79d1' when 8 then '\u7855\u58eb' when 9 then '\u535a\u58eb' end as item, IFNULL(count(r.id), 0) number from record r";
            suffix = "r.status = 3 GROUP BY r.grade;";
        } else if (ObjectUtils.equals((Object)condition, (Object)CONDITION_MAJOR)) {
            prefix = "select r.major item, IFNULL(count(r.id), 0) number from record r";
            suffix = "r.grade >= 5 and r.status = 3 GROUP BY r.major ORDER BY number desc limit 0, 10;";
        } else if (ObjectUtils.equals((Object)condition, (Object)CONDITION_SCHOOL)) {
            prefix = "select r.school item, IFNULL(count(r.id), 0) number from record r";
            suffix = "r.grade >= 5 and r.status = 3 GROUP BY r.school ORDER BY number desc limit 0, 10;";
        }
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            sb.append(prefix);
        }
        if (DataUtils.isNotNullOrEmpty((Object)occupationId) || DataUtils.isNotNullOrEmpty((Object)minStartAt) || DataUtils.isNotNullOrEmpty((Object)maxGraduateAt) || DataUtils.isNotNullOrEmpty((Object)minGraduateAt) || DataUtils.isNotNullOrEmpty((Object)maxGraduateAt)) {
            sb.append(", user u where u.id = r.uid and ");
        } else {
            sb.append(" where ");
        }
        if (DataUtils.isNotNullOrEmpty((Object)minPassAt) || DataUtils.isNotNullOrEmpty((Object)maxPassAt)) {
            if (DataUtils.isNotNullOrEmpty((Object)minPassAt)) {
                sb.append(" r.update_at >= ? and ");
                objectList.add(minPassAt);
            }
            if (DataUtils.isNotNullOrEmpty((Object)maxPassAt)) {
                sb.append(" r.update_at <= ? and ");
                objectList.add(maxPassAt);
            }
        }
        if (DataUtils.isNotNullOrEmpty((Object)occupationId)) {
            sb.append(" u.oid = ? and r.uid = u.id and ");
            objectList.add(occupationId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)minStartAt)) {
            sb.append(" u.start_at >= ? and ");
            objectList.add(minStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)maxStartAt)) {
            sb.append(" u.start_at <= ? and ");
            objectList.add(maxStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)minGraduateAt)) {
            sb.append(" u.graduate_at >= ? and ");
            objectList.add(minGraduateAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)maxGraduateAt)) {
            sb.append(" u.graduate_at <= ? and ");
            objectList.add(maxGraduateAt);
        }
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            sb.append(suffix);
        }
        log.info((Object)("query by sql: [" + sb.toString() + "]"));
        log.info((Object)("execute query sql by params: " + objectList));
        return this.template.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(InDoorStudentStatistics.class), objectList.toArray());
    }

    public Integer getRecordTotalNumber(Integer status) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Integer> objectList = new ArrayList<Integer>();
        sb.append("select count(id) number from record");
        if (DataUtils.isNotNullOrEmpty((Object)status) && status >= Record.STATUS_UNCOMMITTED && status <= Record.STATUS_NO_PASS) {
            sb.append(" where status = ? ");
            objectList.add(status);
        }
        sb.append(";");
        log.info((Object)("count record total number by sql: [" + sb.toString() + "]"));
        log.info((Object)("count record total number by params: " + objectList));
        return ((InDoorStudentStatistics)this.template.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(InDoorStudentStatistics.class), objectList.toArray()).get(0)).getNumber();
    }

    public Long getProvinceIdByProvince(String province) {
        String sql = "select province_id from provinces where province = ?;";
        return ((Provinces)this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(Provinces.class), new Object[]{province}).get(0)).getProvinceId();
    }

    public Long getCityIdByCity(String city) {
        String sql = "select city_id from cities where city = ?;";
        return ((Cities)this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(Cities.class), new Object[]{city}).get(0)).getCityId();
    }

    public Long getCountyIdByCounty(String county, Long cityId) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        String sql = "select county_id from counties where county = ? and city_id = ?;";
        objectList.add(county);
        objectList.add(cityId);
        return ((Counties)this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(Counties.class), objectList.toArray()).get(0)).getCountyId();
    }
}

