/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.RecordLog;
import com.ptteng.common.skill.service.RecordLogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordLogServiceImpl
extends BaseDaoServiceImpl
implements RecordLogService {
    private static final Log log = LogFactory.getLog(RecordLogServiceImpl.class);

    public Long insert(RecordLog recordLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + recordLog));
        if (recordLog == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        recordLog.setCreateAt(Long.valueOf(currentTimeMillis));
        recordLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)recordLog);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + recordLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RecordLog> insertList(List<RecordLog> recordLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (recordLogList == null ? "null" : Integer.valueOf(recordLogList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(recordLogList)) {
            return new ArrayList<RecordLog>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RecordLog recordLog : recordLogList) {
            recordLog.setCreateAt(Long.valueOf(currentTimeMillis));
            recordLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(recordLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + recordLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RecordLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RecordLog recordLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (recordLog == null ? "null" : recordLog.getId())));
        boolean result = false;
        if (recordLog == null) {
            return true;
        }
        recordLog.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)recordLog);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + recordLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + recordLog));
        }
        return result;
    }

    public boolean updateList(List<RecordLog> recordLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (recordLogList == null ? "null" : Integer.valueOf(recordLogList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(recordLogList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RecordLog recordLog : recordLogList) {
            recordLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(recordLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + recordLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + recordLogList.size()));
        return result;
    }

    public RecordLog getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RecordLog recordLog = null;
        if (id == null) {
            return recordLog;
        }
        try {
            recordLog = (RecordLog)this.dao.get(RecordLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return recordLog;
    }

    public List<RecordLog> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List recordLog = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RecordLog>();
        }
        try {
            recordLog = this.dao.getList(RecordLog.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (recordLog == null ? "null" : Integer.valueOf(recordLog.size()))));
        return recordLog;
    }

    public List<Long> getRecordLogIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRecordLogIdsByUidOrderByCreateAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRecordLogIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRecordLogIdsByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getRecordLogIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRecordLogIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRecordLogIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRecordLogIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRecordLogIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

