/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Cities;
import com.ptteng.common.skill.service.CitiesService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CitiesServiceImpl
extends BaseDaoServiceImpl
implements CitiesService {
    private static final Log log = LogFactory.getLog(CitiesServiceImpl.class);

    public Long insert(Cities cities) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + cities));
        if (cities == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        cities.setCreateAt(Long.valueOf(currentTimeMillis));
        cities.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)cities);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + cities));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Cities> insertList(List<Cities> citiesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (citiesList == null ? "null" : Integer.valueOf(citiesList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(citiesList)) {
            return new ArrayList<Cities>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Cities cities : citiesList) {
            cities.setCreateAt(Long.valueOf(currentTimeMillis));
            cities.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(citiesList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + citiesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Cities.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Cities cities) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (cities == null ? "null" : cities.getId())));
        boolean result = false;
        if (cities == null) {
            return true;
        }
        cities.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)cities);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + cities));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + cities));
        }
        return result;
    }

    public boolean updateList(List<Cities> citiesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (citiesList == null ? "null" : Integer.valueOf(citiesList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(citiesList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Cities cities : citiesList) {
            cities.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(citiesList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + citiesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + citiesList.size()));
        return result;
    }

    public Cities getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Cities cities = null;
        if (id == null) {
            return cities;
        }
        try {
            cities = (Cities)this.dao.get(Cities.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return cities;
    }

    public List<Cities> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List cities = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Cities>();
        }
        try {
            cities = this.dao.getList(Cities.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (cities == null ? "null" : Integer.valueOf(cities.size()))));
        return cities;
    }

    public Long getCitiesIdByCity(String city) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by city  : " + city));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getCitiesIdByCity", new Object[]{city});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by city  : " + city));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by provinceId,start,limit  : " + provinceId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCitiesIdsByProvinceIdOrderByCreateAt", new Object[]{provinceId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by provinceId,start,limit)  : " + provinceId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by provinceId  : " + provinceId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCitiesIdsByProvinceIdOrderByCreateAt", new Object[]{provinceId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by provinceId)  : " + provinceId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCitiesIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCitiesIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCitiesIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCitiesIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCitiesIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

