package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.StageReplay;
import com.ptteng.common.skill.service.StageReplayService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class StageReplayServiceImpl extends BaseDaoServiceImpl implements StageReplayService {

 

	private static final Log log = LogFactory.getLog(StageReplayServiceImpl.class);



		   
		@Override
		public Long insert(StageReplay stageReplay)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + stageReplay);

		if (stageReplay == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		stageReplay.setCreateAt(currentTimeMillis);
		stageReplay.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(stageReplay);
		} catch (DaoException e) {
			log.error(" insert wrong : " + stageReplay);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<StageReplay> insertList(List<StageReplay> stageReplayList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (stageReplayList == null ? "null" : stageReplayList.size()));
      
		List<StageReplay> resultList = null;

		if (CollectionUtils.isEmpty(stageReplayList)) {
			return new ArrayList<StageReplay>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (StageReplay stageReplay : stageReplayList) {
			stageReplay.setCreateAt(currentTimeMillis);
			stageReplay.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<StageReplay>) dao.batchSave(stageReplayList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + stageReplayList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(StageReplay.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(StageReplay stageReplay)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (stageReplay == null ? "null" : stageReplay.getId()));

		boolean result = false;

		if (stageReplay == null) {
			return true;
		}

		stageReplay.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(stageReplay);
		} catch (DaoException e) {
			log.error(" update wrong : " + stageReplay);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + stageReplay);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<StageReplay> stageReplayList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (stageReplayList == null ? "null" : stageReplayList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(stageReplayList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (StageReplay stageReplay : stageReplayList) {
			stageReplay.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(stageReplayList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + stageReplayList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + stageReplayList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public StageReplay getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		StageReplay stageReplay = null;

		if (id == null) {
			return stageReplay;
		}

		try {
			stageReplay = (StageReplay) dao.get(StageReplay.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return stageReplay;		
		}	
		  
    	   
		@Override
		public List<StageReplay> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<StageReplay> stageReplay = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<StageReplay>();
		}

		try {
			stageReplay = (List<StageReplay>) dao.getList(StageReplay.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (stageReplay == null ? "null" : stageReplay.size()));
    
		return stageReplay;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStageReplayIdsByNameOrderBySort(String name,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by name,start,limit  : " + name+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getStageReplayIdsByNameOrderBySort", new Object[] { name},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by name,start,limit)  : " + name+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStageReplayIdsByStatusOrderBySort(Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by status,start,limit  : " + status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getStageReplayIdsByStatusOrderBySort", new Object[] { status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStageReplayIdsByNameOrderBySort(String name)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by name  : " + name );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getStageReplayIdsByNameOrderBySort", new Object[] { name});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by name)  : " + name );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStageReplayIdsByStatusOrderBySort(Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by status  : " + status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getStageReplayIdsByStatusOrderBySort", new Object[] { status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by status)  : " + status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getStageReplayIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getStageReplayIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countStageReplayIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getStageReplayIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getStageReplayIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

