package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Cities;
import com.ptteng.common.skill.service.CitiesService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CitiesServiceImpl extends BaseDaoServiceImpl implements CitiesService {

 

	private static final Log log = LogFactory.getLog(CitiesServiceImpl.class);



		   
		@Override
		public Long insert(Cities cities)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + cities);

		if (cities == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		cities.setCreateAt(currentTimeMillis);
		cities.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(cities);
		} catch (DaoException e) {
			log.error(" insert wrong : " + cities);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Cities> insertList(List<Cities> citiesList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (citiesList == null ? "null" : citiesList.size()));
      
		List<Cities> resultList = null;

		if (CollectionUtils.isEmpty(citiesList)) {
			return new ArrayList<Cities>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Cities cities : citiesList) {
			cities.setCreateAt(currentTimeMillis);
			cities.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Cities>) dao.batchSave(citiesList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + citiesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Cities.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Cities cities)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (cities == null ? "null" : cities.getId()));

		boolean result = false;

		if (cities == null) {
			return true;
		}

		cities.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(cities);
		} catch (DaoException e) {
			log.error(" update wrong : " + cities);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + cities);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Cities> citiesList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (citiesList == null ? "null" : citiesList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(citiesList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Cities cities : citiesList) {
			cities.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(citiesList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + citiesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + citiesList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Cities getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Cities cities = null;

		if (id == null) {
			return cities;
		}

		try {
			cities = (Cities) dao.get(Cities.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return cities;		
		}	
		  
    	   
		@Override
		public List<Cities> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Cities> cities = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Cities>();
		}

		try {
			cities = (List<Cities>) dao.getList(Cities.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (cities == null ? "null" : cities.size()));
    
		return cities;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getCitiesIdByCity(String city)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by city  : " + city );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getCitiesIdByCity", new Object[] {city });
   } catch (DaoException e) {
			log.error(" get id wrong by city  : " + city );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by provinceId,start,limit  : " + provinceId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCitiesIdsByProvinceIdOrderByCreateAt", new Object[] { provinceId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by provinceId,start,limit)  : " + provinceId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCitiesIdsByProvinceIdOrderByCreateAt(Long provinceId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by provinceId  : " + provinceId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCitiesIdsByProvinceIdOrderByCreateAt", new Object[] { provinceId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by provinceId)  : " + provinceId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCitiesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCitiesIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCitiesIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCitiesIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCitiesIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

