-- ----------------------------
-- Table structure for `record`
-- ----------------------------
-- DROP TABLE IF EXISTS `record`;
CREATE TABLE `record` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',  
    `avatar` varchar(200) NOT NULL   COMMENT '头像',  
    `name` varchar(50) NOT NULL   COMMENT '姓名',  
    `sex` int(2) NOT NULL   COMMENT '性别',  
    `identity_num` bigint(20) NOT NULL   COMMENT '身份证号',  
    `born_at` bigint(20)    COMMENT '出生日期',  
    `province_id` bigint(20) NOT NULL   COMMENT '省份ID',  
    `city_id` bigint(20) NOT NULL   COMMENT '城市ID',  
    `county_id` bigint(20) NOT NULL   COMMENT '区县ID',
    `educated_start_at` bigint(20) NOT NULL   COMMENT '受教育开始时间',  
    `educated_end_at` bigint(20) NOT NULL   COMMENT '受教育结束时间',  
    `grade` varchar(50) NOT NULL   COMMENT '学历',  
    `school` varchar(50)    COMMENT '毕业学校',
    `schoolType` int(2)    COMMENT '学校级别',
    `major` varchar(50)    COMMENT '专业',
    `is_work` int(2)  NOT NULL  COMMENT '是否有工作经历',
    `work_exp` text    COMMENT '工作经历',
    `contact_name` varchar(50) NOT NULL   COMMENT '紧急联系人姓名'
    `contact_relation` varchar(50) NOT NULL   COMMENT '与紧急联系人的关系'
    `contact_mobile` varchar(50) NOT NULL   COMMENT '紧急联系人手机号'
    `card_num` bigint(20) NOT NULL   COMMENT '银行卡号',
    `bank` varchar(50) NOT NULL   COMMENT '开户行',  
    `source` varchar(50) NOT NULL   COMMENT '报名渠道',  
    `identity_front_url` varchar(200) NOT NULL   COMMENT '身份证正面照片',  
    `identity_reverse_url` varchar(200) NOT NULL   COMMENT '身份证反面照片',  
    `is_loan` int(2) NOT NULL   COMMENT '是否为贷款学员',  
    `household_register_url` varchar(200)    COMMENT '户口簿本人页',  
    `status` int(2) NOT NULL   COMMENT '档案状态',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人ID',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人ID',  
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





