/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.service.IterationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IterationServiceImpl
extends BaseDaoServiceImpl
implements IterationService {
    private static final Log log = LogFactory.getLog(IterationServiceImpl.class);

    public Long insert(Iteration iteration) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + iteration));
        if (iteration == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        iteration.setCreateAt(Long.valueOf(currentTimeMillis));
        iteration.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)iteration);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + iteration));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Iteration> insertList(List<Iteration> iterationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (iterationList == null ? "null" : Integer.valueOf(iterationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(iterationList)) {
            return new ArrayList<Iteration>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Iteration iteration : iterationList) {
            iteration.setCreateAt(Long.valueOf(currentTimeMillis));
            iteration.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(iterationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + iterationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Iteration.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Iteration iteration) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (iteration == null ? "null" : iteration.getId())));
        boolean result = false;
        if (iteration == null) {
            return true;
        }
        iteration.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)iteration);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + iteration));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + iteration));
        }
        return result;
    }

    public boolean updateList(List<Iteration> iterationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (iterationList == null ? "null" : Integer.valueOf(iterationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(iterationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Iteration iteration : iterationList) {
            iteration.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(iterationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + iterationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + iterationList.size()));
        return result;
    }

    public Iteration getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Iteration iteration = null;
        if (id == null) {
            return iteration;
        }
        try {
            iteration = (Iteration)this.dao.get(Iteration.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return iteration;
    }

    public List<Iteration> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List iteration = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Iteration>();
        }
        try {
            iteration = this.dao.getList(Iteration.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (iteration == null ? "null" : Integer.valueOf(iteration.size()))));
        return iteration;
    }

    public List<Long> getIterationIdsByProductIdAndStatusOrderBySort(Long productId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by productId,status,start,limit  : " + productId + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIterationIdsByProductIdAndStatusOrderBySort", new Object[]{productId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by productId,status,start,limit)  : " + productId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countIterationIdsByProductIdAndStatusOrderBySort(Long productId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by productId,status  : " + productId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIterationIdsByProductIdAndStatusOrderBySort", new Object[]{productId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by productId,status)  : " + productId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getIterationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIterationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countIterationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getIterationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getIterationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

