package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.service.IterationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class IterationServiceImpl extends BaseDaoServiceImpl implements IterationService {

 

	private static final Log log = LogFactory.getLog(IterationServiceImpl.class);



		   
		@Override
		public Long insert(Iteration iteration)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + iteration);

		if (iteration == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		iteration.setCreateAt(currentTimeMillis);
		iteration.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(iteration);
		} catch (DaoException e) {
			log.error(" insert wrong : " + iteration);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Iteration> insertList(List<Iteration> iterationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (iterationList == null ? "null" : iterationList.size()));
      
		List<Iteration> resultList = null;

		if (CollectionUtils.isEmpty(iterationList)) {
			return new ArrayList<Iteration>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Iteration iteration : iterationList) {
			iteration.setCreateAt(currentTimeMillis);
			iteration.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Iteration>) dao.batchSave(iterationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + iterationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Iteration.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Iteration iteration)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (iteration == null ? "null" : iteration.getId()));

		boolean result = false;

		if (iteration == null) {
			return true;
		}

		iteration.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(iteration);
		} catch (DaoException e) {
			log.error(" update wrong : " + iteration);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + iteration);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Iteration> iterationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (iterationList == null ? "null" : iterationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(iterationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Iteration iteration : iterationList) {
			iteration.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(iterationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + iterationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + iterationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Iteration getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Iteration iteration = null;

		if (id == null) {
			return iteration;
		}

		try {
			iteration = (Iteration) dao.get(Iteration.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return iteration;		
		}	
		  
    	   
		@Override
		public List<Iteration> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Iteration> iteration = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Iteration>();
		}

		try {
			iteration = (List<Iteration>) dao.getList(Iteration.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (iteration == null ? "null" : iteration.size()));
    
		return iteration;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIterationIdsByProductIdAndStatusOrderBySort(Long productId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by productId,status,start,limit  : " + productId+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getIterationIdsByProductIdAndStatusOrderBySort", new Object[] { productId,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by productId,status,start,limit)  : " + productId+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIterationIdsByProductIdAndStatusOrderBySort(Long productId,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by productId,status  : " + productId+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getIterationIdsByProductIdAndStatusOrderBySort", new Object[] { productId,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by productId,status)  : " + productId+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getIterationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getIterationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countIterationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getIterationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getIterationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

